/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;

public abstract class ExtensionPoint {
    protected final String name;
    protected final Class<?>[] singletons;

    public ExtensionPoint(String name, Class<?> ... singletons) {
        this.name = name;
        this.singletons = singletons;
    }

    public final void bind(Binder binder) {
        for (Class<?> c : this.singletons) {
            binder.bind(c).asEagerSingleton();
        }
        this.bindExtensions(binder);
    }

    protected abstract void bindExtensions(Binder var1);

    public static final class InstanceMap<K, V>
    extends ExtensionPoint {
        private final Map<K, V> map = new HashMap();
        private final Class<K> keyType;
        private final Class<V> valueType;

        public InstanceMap(String name, Class<K> keyType, Class<V> valueType, Class<?> ... singletons) {
            super(name, singletons);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public final void registerExtension(K key, V value) {
            V old = this.map.put(key, value);
            if (old != null) {
                throw new IllegalArgumentException("Cannot register [" + this.name + "] with key [" + key + "] to [" + value + "], already registered to [" + old + "]");
            }
        }

        @Override
        protected void bindExtensions(Binder binder) {
            MapBinder<K, V> mapBinder = MapBinder.newMapBinder(binder, this.keyType, this.valueType);
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                mapBinder.addBinding(entry.getKey()).toInstance(entry.getValue());
            }
        }
    }

    public static final class ClassSet<T>
    extends ExtensionPoint {
        protected final Class<T> extensionClass;
        private final Set<Class<? extends T>> extensions = new HashSet<Class<? extends T>>();

        public ClassSet(String name, Class<T> extensionClass, Class<?> ... singletons) {
            super(name, singletons);
            this.extensionClass = extensionClass;
        }

        public final void registerExtension(Class<? extends T> extension) {
            if (this.extensions.contains(extension)) {
                throw new IllegalArgumentException("Can't register the same [" + this.name + "] more than once for [" + extension.getName() + "]");
            }
            this.extensions.add(extension);
        }

        @Override
        protected final void bindExtensions(Binder binder) {
            Multibinder<T> allocationMultibinder = Multibinder.newSetBinder(binder, this.extensionClass);
            for (Class<? extends T> clazz : this.extensions) {
                binder.bind(clazz).asEagerSingleton();
                allocationMultibinder.addBinding().to(clazz);
            }
        }
    }

    public static final class SelectedType<T>
    extends ClassMap<T> {
        public SelectedType(String name, Class<T> extensionClass) {
            super(name, extensionClass, Collections.EMPTY_SET, new Class[0]);
        }

        public String bindType(Binder binder, Settings settings, String settingsKey, String defaultValue) {
            String type = settings.get(settingsKey, defaultValue);
            if (type == null) {
                throw new IllegalArgumentException("Missing setting [" + settingsKey + "]");
            }
            Class instance = this.getExtension(type);
            if (instance == null) {
                throw new IllegalArgumentException("Unknown [" + this.name + "] type [" + type + "]");
            }
            if (this.extensionClass == instance) {
                binder.bind(this.extensionClass).asEagerSingleton();
            } else {
                binder.bind(this.extensionClass).to(instance).asEagerSingleton();
            }
            return type;
        }
    }

    public static class ClassMap<T>
    extends ExtensionPoint {
        protected final Class<T> extensionClass;
        private final Map<String, Class<? extends T>> extensions = new HashMap<String, Class<? extends T>>();
        private final Set<String> reservedKeys;

        public ClassMap(String name, Class<T> extensionClass, Set<String> reservedKeys, Class<?> ... singletons) {
            super(name, singletons);
            this.extensionClass = extensionClass;
            this.reservedKeys = reservedKeys;
        }

        public Class<? extends T> getExtension(String type) {
            return this.extensions.get(type);
        }

        public final void registerExtension(String key, Class<? extends T> extension) {
            if (this.extensions.containsKey(key) || this.reservedKeys.contains(key)) {
                throw new IllegalArgumentException("Can't register the same [" + this.name + "] more than once for [" + key + "]");
            }
            this.extensions.put(key, extension);
        }

        @Override
        protected final void bindExtensions(Binder binder) {
            MapBinder<String, T> parserMapBinder = MapBinder.newMapBinder(binder, String.class, this.extensionClass);
            for (Map.Entry<String, Class<T>> clazz : this.extensions.entrySet()) {
                parserMapBinder.addBinding(clazz.getKey()).to(clazz.getValue());
            }
        }
    }
}

