/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerProviderFactory;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactoryFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltCharFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class AnalysisService
extends AbstractIndexComponent
implements Closeable {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(AnalysisService.class));
    private final ImmutableMap<String, NamedAnalyzer> analyzers;
    private final ImmutableMap<String, TokenizerFactory> tokenizers;
    private final ImmutableMap<String, CharFilterFactory> charFilters;
    private final ImmutableMap<String, TokenFilterFactory> tokenFilters;
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final NamedAnalyzer defaultSearchAnalyzer;
    private final NamedAnalyzer defaultSearchQuoteAnalyzer;

    public AnalysisService(Index index, Settings indexSettings) {
        this(index, indexSettings, null, null, null, null, null);
    }

    @Inject
    public AnalysisService(Index index, IndexSettingsService indexSettingsService, @Nullable IndicesAnalysisService indicesAnalysisService, @Nullable Map<String, AnalyzerProviderFactory> analyzerFactoryFactories, @Nullable Map<String, TokenizerFactoryFactory> tokenizerFactoryFactories, @Nullable Map<String, CharFilterFactoryFactory> charFilterFactoryFactories, @Nullable Map<String, TokenFilterFactoryFactory> tokenFilterFactoryFactories) {
        this(index, indexSettingsService.getSettings(), indicesAnalysisService, analyzerFactoryFactories, tokenizerFactoryFactories, charFilterFactoryFactories, tokenFilterFactoryFactories);
    }

    /*
     * WARNING - void declaration
     */
    AnalysisService(Index index, Settings indexSettings, @Nullable IndicesAnalysisService indicesAnalysisService, @Nullable Map<String, AnalyzerProviderFactory> analyzerFactoryFactories, @Nullable Map<String, TokenizerFactoryFactory> tokenizerFactoryFactories, @Nullable Map<String, CharFilterFactoryFactory> charFilterFactoryFactories, @Nullable Map<String, TokenFilterFactoryFactory> tokenFilterFactoryFactories) {
        super(index, indexSettings);
        Settings defaultSettings = Settings.builder().put("index.version.created", Version.indexCreated(indexSettings)).build();
        HashMap tokenizers = Maps.newHashMap();
        if (tokenizerFactoryFactories != null) {
            Map<String, Settings> tokenizersSettings = indexSettings.getGroups("index.analysis.tokenizer");
            for (Map.Entry<String, TokenizerFactoryFactory> entry : tokenizerFactoryFactories.entrySet()) {
                void var15_58;
                String string = entry.getKey();
                TokenizerFactoryFactory tokenizerFactoryFactory = entry.getValue();
                Settings settings = (Settings)tokenizersSettings.get(string);
                if (settings == null) {
                    Settings settings2 = defaultSettings;
                }
                TokenizerFactory tokenizerFactory = tokenizerFactoryFactory.create(string, (Settings)var15_58);
                tokenizers.put(string, tokenizerFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry entry : indicesAnalysisService.tokenizerFactories().entrySet()) {
                String string = (String)entry.getKey();
                if (tokenizers.containsKey(string)) continue;
                tokenizers.put(string, ((PreBuiltTokenizerFactoryFactory)entry.getValue()).create(string, defaultSettings));
            }
        }
        this.tokenizers = ImmutableMap.copyOf((Map)tokenizers);
        HashMap charFilters = Maps.newHashMap();
        if (charFilterFactoryFactories != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.analysis.char_filter");
            for (Map.Entry<String, CharFilterFactoryFactory> entry : charFilterFactoryFactories.entrySet()) {
                String string = entry.getKey();
                CharFilterFactoryFactory charFilterFactoryFactory = entry.getValue();
                Settings charFilterSettings = map.get(string);
                if (charFilterSettings == null) {
                    charFilterSettings = defaultSettings;
                }
                CharFilterFactory tokenFilterFactory = charFilterFactoryFactory.create(string, charFilterSettings);
                charFilters.put(string, tokenFilterFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltCharFilterFactoryFactory> entry : indicesAnalysisService.charFilterFactories().entrySet()) {
                String string = entry.getKey();
                if (charFilters.containsKey(string)) continue;
                charFilters.put(string, entry.getValue().create(string, defaultSettings));
            }
        }
        this.charFilters = ImmutableMap.copyOf((Map)charFilters);
        HashMap hashMap = Maps.newHashMap();
        if (tokenFilterFactoryFactories != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.analysis.filter");
            for (Map.Entry<String, TokenFilterFactoryFactory> entry : tokenFilterFactoryFactories.entrySet()) {
                String string = entry.getKey();
                TokenFilterFactoryFactory tokenFilterFactoryFactory = entry.getValue();
                Settings tokenFilterSettings = map.get(string);
                if (tokenFilterSettings == null) {
                    tokenFilterSettings = defaultSettings;
                }
                TokenFilterFactory tokenFilterFactory = tokenFilterFactoryFactory.create(string, tokenFilterSettings);
                hashMap.put(string, tokenFilterFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltTokenFilterFactoryFactory> entry : indicesAnalysisService.tokenFilterFactories().entrySet()) {
                String string = entry.getKey();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, entry.getValue().create(string, defaultSettings));
            }
        }
        this.tokenFilters = ImmutableMap.copyOf((Map)hashMap);
        HashMap hashMap2 = Maps.newHashMap();
        if (analyzerFactoryFactories != null) {
            Map<String, Settings> map = indexSettings.getGroups("index.analysis.analyzer");
            for (Map.Entry<String, AnalyzerProviderFactory> entry : analyzerFactoryFactories.entrySet()) {
                String analyzerName = entry.getKey();
                AnalyzerProviderFactory analyzerFactoryFactory = entry.getValue();
                Settings analyzerSettings = map.get(analyzerName);
                if (analyzerSettings == null) {
                    analyzerSettings = defaultSettings;
                }
                AnalyzerProvider analyzerFactory = analyzerFactoryFactory.create(analyzerName, analyzerSettings);
                hashMap2.put(analyzerName, analyzerFactory);
            }
        }
        if (indicesAnalysisService != null) {
            for (Map.Entry<String, PreBuiltAnalyzerProviderFactory> entry : indicesAnalysisService.analyzerProviderFactories().entrySet()) {
                String string = entry.getKey();
                Version indexVersion = Version.indexCreated(indexSettings);
                if (hashMap2.containsKey(string)) continue;
                hashMap2.put(string, entry.getValue().create(string, Settings.settingsBuilder().put("index.version.created", indexVersion).build()));
            }
        }
        if (!hashMap2.containsKey("default")) {
            hashMap2.put("default", new StandardAnalyzerProvider(index, indexSettings, null, "default", Settings.Builder.EMPTY_SETTINGS));
        }
        if (!hashMap2.containsKey("default_index")) {
            hashMap2.put("default_index", hashMap2.get("default"));
        }
        if (!hashMap2.containsKey("default_search")) {
            hashMap2.put("default_search", hashMap2.get("default"));
        }
        if (!hashMap2.containsKey("default_search_quoted")) {
            hashMap2.put("default_search_quoted", hashMap2.get("default_search"));
        }
        HashMap hashMap3 = Maps.newHashMap();
        for (AnalyzerProvider analyzerProvider : hashMap2.values()) {
            String[] aliases;
            NamedAnalyzer analyzer;
            Object analyzerF;
            int overridePositionIncrementGap = StringFieldMapper.Defaults.positionIncrementGap(Version.indexCreated(indexSettings));
            if (analyzerProvider instanceof CustomAnalyzerProvider) {
                ((CustomAnalyzerProvider)analyzerProvider).build(this);
                overridePositionIncrementGap = Integer.MIN_VALUE;
            }
            if ((analyzerF = analyzerProvider.get()) == null) {
                throw new IllegalArgumentException("analyzer [" + analyzerProvider.name() + "] created null analyzer");
            }
            if (analyzerF instanceof NamedAnalyzer) {
                analyzer = (NamedAnalyzer)((Object)analyzerF);
                if (overridePositionIncrementGap >= 0 && analyzer.getPositionIncrementGap(analyzer.name()) != overridePositionIncrementGap) {
                    analyzer = new NamedAnalyzer(analyzer, overridePositionIncrementGap);
                }
            } else {
                analyzer = new NamedAnalyzer(analyzerProvider.name(), analyzerProvider.scope(), (Analyzer)analyzerF, overridePositionIncrementGap);
            }
            hashMap3.put(analyzerProvider.name(), analyzer);
            String strAliases = indexSettings.get("index.analysis.analyzer." + analyzerProvider.name() + ".alias");
            if (strAliases != null) {
                for (String alias : Strings.commaDelimitedListToStringArray(strAliases)) {
                    hashMap3.put(alias, analyzer);
                }
            }
            for (String alias : aliases = indexSettings.getAsArray("index.analysis.analyzer." + analyzerProvider.name() + ".alias")) {
                hashMap3.put(alias, analyzer);
            }
        }
        NamedAnalyzer namedAnalyzer = (NamedAnalyzer)((Object)hashMap3.get("default"));
        if (namedAnalyzer == null) {
            throw new IllegalArgumentException("no default analyzer configured");
        }
        if (hashMap3.containsKey("default_index")) {
            this.deprecationLogger.deprecated("setting [index.analysis.analyzer.default_index] is deprecated, use [index.analysis.analyzer.default] instead for index [{}]", index.getName());
        }
        this.defaultIndexAnalyzer = hashMap3.containsKey("default_index") ? (NamedAnalyzer)((Object)hashMap3.get("default_index")) : namedAnalyzer;
        this.defaultSearchAnalyzer = hashMap3.containsKey("default_search") ? (NamedAnalyzer)((Object)hashMap3.get("default_search")) : namedAnalyzer;
        this.defaultSearchQuoteAnalyzer = hashMap3.containsKey("default_search_quote") ? (NamedAnalyzer)((Object)hashMap3.get("default_search_quote")) : this.defaultSearchAnalyzer;
        for (Map.Entry analyzer : hashMap3.entrySet()) {
            if (!((String)analyzer.getKey()).startsWith("_")) continue;
            throw new IllegalArgumentException("analyzer name must not start with '_'. got \"" + (String)analyzer.getKey() + "\"");
        }
        this.analyzers = ImmutableMap.copyOf((Map)hashMap3);
    }

    @Override
    public void close() {
        for (NamedAnalyzer analyzer : this.analyzers.values()) {
            if (analyzer.scope() != AnalyzerScope.INDEX) continue;
            try {
                analyzer.close();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                this.logger.debug("failed to close analyzer " + (Object)((Object)analyzer), new Object[0]);
            }
        }
    }

    public NamedAnalyzer analyzer(String name) {
        NamedAnalyzer analyzer = (NamedAnalyzer)((Object)this.analyzers.get((Object)name));
        if (analyzer != null) {
            return analyzer;
        }
        String underscoreName = Strings.toUnderscoreCase(name);
        analyzer = (NamedAnalyzer)((Object)this.analyzers.get((Object)underscoreName));
        if (analyzer != null) {
            DEPRECATION_LOGGER.deprecated("Deprecated analyzer name [" + name + "], use [" + underscoreName + "] instead", new Object[0]);
        }
        return analyzer;
    }

    public NamedAnalyzer defaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    public NamedAnalyzer defaultSearchAnalyzer() {
        return this.defaultSearchAnalyzer;
    }

    public NamedAnalyzer defaultSearchQuoteAnalyzer() {
        return this.defaultSearchQuoteAnalyzer;
    }

    public TokenizerFactory tokenizer(String name) {
        TokenizerFactory tokenizerFactory = (TokenizerFactory)this.tokenizers.get((Object)name);
        if (tokenizerFactory != null) {
            return tokenizerFactory;
        }
        String underscoreName = Strings.toUnderscoreCase(name);
        tokenizerFactory = (TokenizerFactory)this.tokenizers.get((Object)underscoreName);
        if (tokenizerFactory != null) {
            DEPRECATION_LOGGER.deprecated("Deprecated tokenizer name [" + name + "], use [" + underscoreName + "] instead", new Object[0]);
        }
        return tokenizerFactory;
    }

    public CharFilterFactory charFilter(String name) {
        CharFilterFactory charFilterFactory = (CharFilterFactory)this.charFilters.get((Object)name);
        if (charFilterFactory != null) {
            return charFilterFactory;
        }
        String underscoreName = Strings.toUnderscoreCase(name);
        charFilterFactory = (CharFilterFactory)this.charFilters.get((Object)underscoreName);
        if (charFilterFactory != null) {
            DEPRECATION_LOGGER.deprecated("Deprecated char_filter name [" + name + "], use [" + underscoreName + "] instead", new Object[0]);
        }
        return charFilterFactory;
    }

    public TokenFilterFactory tokenFilter(String name) {
        TokenFilterFactory tokenFilterFactory = (TokenFilterFactory)this.tokenFilters.get((Object)name);
        if (tokenFilterFactory != null) {
            return tokenFilterFactory;
        }
        String underscoreName = Strings.toUnderscoreCase(name);
        tokenFilterFactory = (TokenFilterFactory)this.tokenFilters.get((Object)underscoreName);
        if (tokenFilterFactory != null) {
            DEPRECATION_LOGGER.deprecated("Deprecated token_filter name [" + name + "], use [" + underscoreName + "] instead", new Object[0]);
        }
        return tokenFilterFactory;
    }
}

