/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.script;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestDeleteIndexedScriptAction
extends BaseRestHandler {
    @Inject
    public RestDeleteIndexedScriptAction(Settings settings, RestController controller, Client client) {
        this(settings, controller, true, client);
    }

    protected RestDeleteIndexedScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers, Client client) {
        super(settings, controller, client);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.DELETE, "/_scripts/{lang}/{id}", this);
        }
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        DeleteIndexedScriptRequest deleteIndexedScriptRequest = new DeleteIndexedScriptRequest(this.getScriptLang(request), request.param("id"));
        deleteIndexedScriptRequest.version(request.paramAsLong("version", deleteIndexedScriptRequest.version()));
        deleteIndexedScriptRequest.versionType(VersionType.fromString(request.param("version_type"), deleteIndexedScriptRequest.versionType()));
        client.deleteIndexedScript(deleteIndexedScriptRequest, (ActionListener<DeleteIndexedScriptResponse>)new RestBuilderListener<DeleteIndexedScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(DeleteIndexedScriptResponse result, XContentBuilder builder) throws Exception {
                builder.startObject().field(Fields.FOUND, result.isFound()).field(Fields._INDEX, result.getIndex()).field(Fields._TYPE, result.getType()).field(Fields._ID, result.getId()).field(Fields._VERSION, result.getVersion()).endObject();
                RestStatus status = RestStatus.OK;
                if (!result.isFound()) {
                    status = RestStatus.NOT_FOUND;
                }
                return new BytesRestResponse(status, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString FOUND = new XContentBuilderString("found");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");

        Fields() {
        }
    }
}

