/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.Address;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.DaemonStateCoordinator;
import org.gradle.launcher.daemon.server.DefaultIncomingConnectionHandler;
import org.gradle.launcher.daemon.server.DomainRegistryUpdater;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;

public class Daemon
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(Daemon.class);
    private final DaemonServerConnector connector;
    private final DaemonRegistry daemonRegistry;
    private final DaemonContext daemonContext;
    private final DaemonCommandExecuter commandExecuter;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorFactory executorFactory;
    private DaemonStateCoordinator stateCoordinator;
    private final Lock lifecycleLock = new ReentrantLock();
    private Address connectorAddress;
    private DomainRegistryUpdater registryUpdater;
    private DefaultIncomingConnectionHandler connectionHandler;

    public Daemon(DaemonServerConnector connector, DaemonRegistry daemonRegistry, DaemonContext daemonContext, DaemonCommandExecuter commandExecuter, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService) {
        this.connector = connector;
        this.daemonRegistry = daemonRegistry;
        this.daemonContext = daemonContext;
        this.commandExecuter = commandExecuter;
        this.executorFactory = executorFactory;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public String getUid() {
        return this.daemonContext.getUid();
    }

    public Address getAddress() {
        return this.connectorAddress;
    }

    public DaemonContext getDaemonContext() {
        return this.daemonContext;
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.daemonRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.info("start() called on daemon - {}", (Object)this.daemonContext);
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator != null) {
                throw new IllegalStateException("cannot start daemon as it is already running");
            }
            SecureRandom secureRandom = new SecureRandom();
            byte[] token = new byte[16];
            secureRandom.nextBytes(token);
            this.registryUpdater = new DomainRegistryUpdater(this.daemonRegistry, this.daemonContext, token);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Daemon.this.daemonRegistry.remove(Daemon.this.connectorAddress);
                    }
                    catch (Exception e) {
                        LOGGER.debug("VM shutdown hook was unable to remove the daemon address from the registry. It will be cleaned up later.", (Throwable)e);
                    }
                }
            });
            Runnable onStartCommand = new Runnable(){

                public void run() {
                    Daemon.this.registryUpdater.onStartActivity();
                }
            };
            Runnable onFinishCommand = new Runnable(){

                public void run() {
                    Daemon.this.registryUpdater.onCompleteActivity();
                }
            };
            this.stateCoordinator = new DaemonStateCoordinator(this.executorFactory, onStartCommand, onFinishCommand);
            this.connectionHandler = new DefaultIncomingConnectionHandler(this.commandExecuter, this.daemonContext, this.stateCoordinator, this.executorFactory, token);
            Runnable connectionErrorHandler = new Runnable(){

                public void run() {
                    Daemon.this.stateCoordinator.stop();
                }
            };
            this.connectorAddress = this.connector.start(this.connectionHandler, connectionErrorHandler);
            LOGGER.debug("Daemon starting at: {}, with address: {}", (Object)new Date(), (Object)this.connectorAddress);
            this.registryUpdater.onStart(this.connectorAddress);
        }
        finally {
            this.lifecycleLock.unlock();
        }
        LOGGER.lifecycle("Daemon server started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.debug("stop() called on daemon");
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot stop daemon as it has not been started.");
            }
            LOGGER.info("Stop requested. Daemon is removing its presence from the registry...");
            this.scheduledExecutorService.shutdown();
            CompositeStoppable.stoppable(this.stateCoordinator, this.registryUpdater, this.connector, this.connectionHandler).stop();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stopOnExpiration(DaemonExpirationStrategy expirationStrategy, int checkIntervalMills) {
        LOGGER.debug("stopOnExpiration() called on daemon");
        DaemonExpirationPeriodicCheck periodicCheck = new DaemonExpirationPeriodicCheck(this, expirationStrategy);
        this.scheduledExecutorService.scheduleAtFixedRate(periodicCheck, checkIntervalMills, checkIntervalMills, TimeUnit.MILLISECONDS);
        this.awaitExpiration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitExpiration() {
        DaemonStateCoordinator stateCoordinator;
        LOGGER.debug("awaitExpiration() called on daemon");
        this.lifecycleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot await stop on daemon as it has not been started.");
            }
            stateCoordinator = this.stateCoordinator;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        stateCoordinator.awaitStop();
    }

    DaemonStateCoordinator getStateCoordinator() {
        return this.stateCoordinator;
    }

    private static class DaemonExpirationPeriodicCheck
    implements Runnable {
        private final Daemon daemon;
        private DaemonExpirationStrategy expirationStrategy;

        DaemonExpirationPeriodicCheck(Daemon daemon, DaemonExpirationStrategy expirationStrategy) {
            this.daemon = daemon;
            this.expirationStrategy = expirationStrategy;
        }

        public void run() {
            LOGGER.debug("DaemonExpirationPeriodicCheck running");
            DaemonExpirationResult expirationCheck = this.expirationStrategy.checkExpiration(this.daemon);
            if (expirationCheck.isExpired()) {
                LOGGER.info("Daemon expiration criteria met, requesting stop");
                LOGGER.lifecycle("Daemon stopping because " + expirationCheck.getReason());
                this.daemon.getStateCoordinator().requestStop();
            }
        }
    }
}

