/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.remote.services.MessagingServices;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonContextBuilder;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonTcpServerConnector;
import org.gradle.launcher.daemon.server.exec.DefaultDaemonCommandExecuter;
import org.gradle.launcher.daemon.server.health.DaemonHealthServices;
import org.gradle.launcher.daemon.server.health.DefaultDaemonHealthServices;
import org.gradle.launcher.exec.BuildExecuter;

public class DaemonServices
extends DefaultServiceRegistry {
    private final DaemonServerConfiguration configuration;
    private final LoggingManagerInternal loggingManager;
    private static final Logger LOGGER = Logging.getLogger(DaemonServices.class);

    public DaemonServices(DaemonServerConfiguration configuration, ServiceRegistry loggingServices, LoggingManagerInternal loggingManager, ClassPath additionalModuleClassPath) {
        super(new ServiceRegistry[]{NativeServices.getInstance(), loggingServices});
        this.configuration = configuration;
        this.loggingManager = loggingManager;
        this.addProvider(new DaemonRegistryServices(configuration.getBaseDir()));
        this.addProvider(new GlobalScopeServices(true, additionalModuleClassPath));
    }

    protected DaemonContext createDaemonContext() {
        DaemonContextBuilder builder = new DaemonContextBuilder(this.get(ProcessEnvironment.class));
        builder.setDaemonRegistryDir(this.configuration.getBaseDir());
        builder.setIdleTimeout(this.configuration.getIdleTimeout());
        builder.setUid(this.configuration.getUid());
        LOGGER.debug("Creating daemon context with opts: {}", this.configuration.getJvmOptions());
        builder.setDaemonOpts(this.configuration.getJvmOptions());
        return builder.create();
    }

    public File getDaemonLogFile() {
        DaemonContext daemonContext = this.get(DaemonContext.class);
        Long pid = daemonContext.getPid();
        String fileName = "daemon-" + (pid == null ? UUID.randomUUID() : pid) + ".out.log";
        return new File(this.get(DaemonDir.class).getVersionedDir(), fileName);
    }

    protected DaemonHealthServices createDaemonHealthServices(ScheduledExecutorService scheduledExecutorService) {
        return new DefaultDaemonHealthServices(scheduledExecutorService);
    }

    protected ScheduledExecutorService createScheduledExecutorService() {
        return Executors.newScheduledThreadPool(1);
    }

    protected Daemon createDaemon(BuildExecuter buildActionExecuter) {
        return new Daemon(new DaemonTcpServerConnector(this.get(ExecutorFactory.class), (InetAddressFactory)this.get(MessagingServices.class).get(InetAddressFactory.class)), this.get(DaemonRegistry.class), this.get(DaemonContext.class), new DefaultDaemonCommandExecuter(buildActionExecuter, this, this.get(ProcessEnvironment.class), this.loggingManager, this.getDaemonLogFile(), this.get(DaemonHealthServices.class)), this.get(ExecutorFactory.class), this.get(ScheduledExecutorService.class));
    }
}

