/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.BackingFileExtractor;
import org.gradle.api.internal.changedetection.state.CachingTreeVisitor;
import org.gradle.api.internal.changedetection.state.OverlappingDirectoriesDetector;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeVisitorCacheExpirationStrategy
implements Stoppable {
    private static final Logger LOG = Logging.getLogger(TreeVisitorCacheExpirationStrategy.class);
    private final CachingTreeVisitor cachingTreeVisitor;
    private final ListenerManager listenerManager;
    private Map<String, Collection<String>> lastTaskToHandleInputFile;
    private Set<String> tasksWithUnknownInputs;
    private Set<String> tasksWithUnknownOutputs;
    private final TreeVisitorCacheTaskExecutionListener taskExecutionListener = new TreeVisitorCacheTaskExecutionListener();
    private final TreeVisitorCacheBuildAdapter buildListener = new TreeVisitorCacheBuildAdapter();
    private final TreeVisitorCacheTaskExecutionGraphListener taskExecutionGraphListener = new TreeVisitorCacheTaskExecutionGraphListener();
    private final boolean swallowExceptions;

    public TreeVisitorCacheExpirationStrategy(CachingTreeVisitor cachingTreeVisitor, ListenerManager listenerManager) {
        this(cachingTreeVisitor, listenerManager, true);
    }

    public TreeVisitorCacheExpirationStrategy(CachingTreeVisitor cachingTreeVisitor, ListenerManager listenerManager, boolean swallowExceptions) {
        this.cachingTreeVisitor = cachingTreeVisitor;
        this.listenerManager = listenerManager;
        this.swallowExceptions = swallowExceptions;
        this.registerListeners();
    }

    private void registerListeners() {
        if (CachingTreeVisitor.CACHING_TREE_VISITOR_FEATURE_ENABLED) {
            this.listenerManager.addListener((Object)this.buildListener);
            this.listenerManager.addListener((Object)this.taskExecutionGraphListener);
            this.listenerManager.addListener((Object)this.taskExecutionListener);
        }
    }

    private void removeListeners() {
        if (CachingTreeVisitor.CACHING_TREE_VISITOR_FEATURE_ENABLED) {
            this.listenerManager.removeListener((Object)this.taskExecutionListener);
            this.listenerManager.removeListener((Object)this.taskExecutionGraphListener);
            this.listenerManager.removeListener((Object)this.buildListener);
        }
    }

    public void stop() {
        this.removeListeners();
    }

    private void clearCache() {
        this.cachingTreeVisitor.clearCache();
        this.cachingTreeVisitor.updateCacheableFilePaths(null);
        this.lastTaskToHandleInputFile = null;
        this.tasksWithUnknownOutputs = null;
        this.tasksWithUnknownInputs = null;
    }

    private void resolveCacheableFilesAndLastTasksToHandleEachFile(TaskExecutionGraph graph) {
        ArrayList<String> cacheableFilePaths = new ArrayList<String>();
        this.tasksWithUnknownInputs = new HashSet<String>();
        this.tasksWithUnknownOutputs = new HashSet<String>();
        HashMap<String, List<String>> inputFileToTaskPaths = new HashMap<String, List<String>>();
        HashSet<String> cumulatedInputsAndOutputs = new HashSet<String>();
        OverlappingDirectoriesDetector detector = new OverlappingDirectoriesDetector();
        for (Task task : graph.getAllTasks()) {
            String taskPath = task.getPath();
            List<String> inputPaths = this.extractFilePaths(task.getInputs().getFiles());
            if (inputPaths.size() > 0) {
                this.storeFilesToMapWithTaskPathAsKey(taskPath, inputPaths, inputFileToTaskPaths);
                for (String path : inputPaths) {
                    if (!cumulatedInputsAndOutputs.contains(path)) continue;
                    cacheableFilePaths.add(path);
                }
                cumulatedInputsAndOutputs.addAll(inputPaths);
            } else if (!task.getInputs().getHasInputs() && !task.getActions().isEmpty()) {
                this.tasksWithUnknownInputs.add(taskPath);
            }
            List<String> outputPaths = this.extractFilePaths(task.getOutputs().getFiles());
            if (outputPaths.size() > 0) {
                cumulatedInputsAndOutputs.addAll(outputPaths);
                detector.addPaths(outputPaths);
                continue;
            }
            if (task.getOutputs().getHasOutput() || task.getActions().isEmpty()) continue;
            this.tasksWithUnknownOutputs.add(taskPath);
        }
        cacheableFilePaths.removeAll(detector.resolveOverlappingPaths());
        this.resolveLastTasksToHandleEachFile(inputFileToTaskPaths, new HashSet<String>(cacheableFilePaths));
        this.cachingTreeVisitor.updateCacheableFilePaths(cacheableFilePaths);
    }

    private void resolveLastTasksToHandleEachFile(Map<String, List<String>> inputFileToTaskPaths, Collection<String> cacheableFilePaths) {
        this.lastTaskToHandleInputFile = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, List<String>> entry : inputFileToTaskPaths.entrySet()) {
            String filePath = entry.getKey();
            if (!cacheableFilePaths.contains(filePath)) continue;
            String lastTaskPath = entry.getValue().get(entry.getValue().size() - 1);
            Collection<String> filePaths = this.lastTaskToHandleInputFile.get(lastTaskPath);
            if (filePaths == null) {
                filePaths = new ArrayList<String>();
                this.lastTaskToHandleInputFile.put(lastTaskPath, filePaths);
            }
            filePaths.add(filePath);
        }
    }

    private void storeFilesToMapWithTaskPathAsKey(String taskPath, List<String> files, Map<String, List<String>> map) {
        for (String filePath : files) {
            List<String> currentTaskPaths = map.get(filePath);
            if (currentTaskPaths == null) {
                currentTaskPaths = new ArrayList<String>();
                map.put(filePath, currentTaskPaths);
            }
            currentTaskPaths.add(taskPath);
        }
    }

    private List<String> extractFilePaths(FileCollection files) {
        List<BackingFileExtractor.FileEntry> entries = new BackingFileExtractor().extractFilesOrDirectories(files);
        return CollectionUtils.collect(entries, (Transformer)new Transformer<String, BackingFileExtractor.FileEntry>(){

            public String transform(BackingFileExtractor.FileEntry fileEntry) {
                return fileEntry.getFile().getAbsolutePath();
            }
        });
    }

    private class TreeVisitorCacheBuildAdapter
    extends BuildAdapter {
        private TreeVisitorCacheBuildAdapter() {
        }

        public void buildFinished(BuildResult result) {
            TreeVisitorCacheExpirationStrategy.this.clearCache();
        }
    }

    private class TreeVisitorCacheTaskExecutionListener
    implements TaskExecutionListener {
        private TreeVisitorCacheTaskExecutionListener() {
        }

        public void beforeExecute(Task task) {
            String taskPath = task.getPath();
            if (TreeVisitorCacheExpirationStrategy.this.tasksWithUnknownInputs != null && TreeVisitorCacheExpirationStrategy.this.tasksWithUnknownInputs.contains(taskPath)) {
                LOG.info("Flushing directory cache because task {} has unknown inputs at configuration time.", (Object)taskPath);
                TreeVisitorCacheExpirationStrategy.this.cachingTreeVisitor.clearCache();
            }
        }

        public void afterExecute(Task task, TaskState state) {
            Collection filePaths;
            String taskPath = task.getPath();
            if (TreeVisitorCacheExpirationStrategy.this.tasksWithUnknownOutputs != null && TreeVisitorCacheExpirationStrategy.this.tasksWithUnknownOutputs.contains(taskPath)) {
                LOG.info("Flushing directory cache because task {} has unknown outputs at configuration time.", (Object)taskPath);
                TreeVisitorCacheExpirationStrategy.this.cachingTreeVisitor.clearCache();
            } else if (TreeVisitorCacheExpirationStrategy.this.lastTaskToHandleInputFile != null && (filePaths = (Collection)TreeVisitorCacheExpirationStrategy.this.lastTaskToHandleInputFile.get(taskPath)) != null) {
                TreeVisitorCacheExpirationStrategy.this.cachingTreeVisitor.invalidateFilePaths(filePaths);
            }
        }
    }

    private class TreeVisitorCacheTaskExecutionGraphListener
    implements TaskExecutionGraphListener {
        private TreeVisitorCacheTaskExecutionGraphListener() {
        }

        public void graphPopulated(TaskExecutionGraph graph) {
            block3: {
                try {
                    TreeVisitorCacheExpirationStrategy.this.resolveCacheableFilesAndLastTasksToHandleEachFile(graph);
                }
                catch (RuntimeException e) {
                    LOG.info("Exception '{}' while resolving task inputs and outputs. Disabling tree visitor caching for this build.", (Object)e.getMessage());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception details", (Throwable)e);
                    }
                    TreeVisitorCacheExpirationStrategy.this.clearCache();
                    if (TreeVisitorCacheExpirationStrategy.this.swallowExceptions) break block3;
                    throw e;
                }
            }
        }
    }
}

