/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.source;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.io.LinePerThreadBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;

abstract class PrintStreamLoggingSystem
implements LoggingSourceSystem {
    private final AtomicReference<StandardOutputListener> destination = new AtomicReference();
    private final PrintStream outstr = new LinePerThreadBufferingOutputStream(new TextStream(){

        public void text(String output) {
            ((StandardOutputListener)PrintStreamLoggingSystem.this.destination.get()).onOutput(output);
        }

        public void endOfStream(@Nullable Throwable failure) {
        }
    });
    private PrintStreamDestination original;
    private LogLevel logLevel;
    private final StandardOutputListener listener;
    private final OutputEventListener outputEventListener;

    protected PrintStreamLoggingSystem(OutputEventListener listener, String category, TimeProvider timeProvider) {
        this.outputEventListener = listener;
        this.listener = new OutputEventDestination(listener, category, timeProvider);
    }

    protected abstract PrintStream get();

    protected abstract void set(PrintStream var1);

    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.logLevel);
    }

    public void restore(LoggingSystem.Snapshot state) {
        SnapshotImpl snapshot = (SnapshotImpl)state;
        if (snapshot.logLevel == null) {
            this.off();
        } else {
            this.on(snapshot.logLevel, snapshot.logLevel);
        }
    }

    public LoggingSystem.Snapshot on(LogLevel minimumLevel, LogLevel defaultLevel) {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (this.original == null) {
            PrintStream originalStream = this.get();
            this.original = new PrintStreamDestination(originalStream);
        }
        this.outstr.flush();
        if (this.get() != this.outstr) {
            this.set(this.outstr);
        }
        this.logLevel = defaultLevel;
        this.outputEventListener.onOutput(new LogLevelChangeEvent(this.logLevel));
        this.destination.set(this.listener);
        return snapshot;
    }

    private LoggingSystem.Snapshot off() {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (this.original != null && this.logLevel != null) {
            this.outstr.flush();
            this.destination.set(this.original);
            this.set(this.original.originalStream);
            this.logLevel = null;
        }
        return snapshot;
    }

    private static class OutputEventDestination
    implements StandardOutputListener {
        private final OutputEventListener listener;
        private final String category;
        private final TimeProvider timeProvider;

        public OutputEventDestination(OutputEventListener listener, String category, TimeProvider timeProvider) {
            this.listener = listener;
            this.category = category;
            this.timeProvider = timeProvider;
        }

        public void onOutput(CharSequence output) {
            this.listener.onOutput(new StyledTextOutputEvent(this.timeProvider.getCurrentTime(), this.category, output.toString()));
        }
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel logLevel;

        public SnapshotImpl(LogLevel logLevel) {
            this.logLevel = logLevel;
        }
    }

    private static class PrintStreamDestination
    implements StandardOutputListener {
        private final PrintStream originalStream;

        public PrintStreamDestination(PrintStream originalStream) {
            this.originalStream = originalStream;
        }

        public void onOutput(CharSequence output) {
            this.originalStream.print(output);
        }
    }
}

