/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.io.File;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.LocalComponentArtifactIdentifier;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.GUtil;

public class PublishArtifactLocalArtifactMetaData
implements LocalComponentArtifactIdentifier,
ComponentArtifactMetaData,
Buildable {
    private final ComponentIdentifier componentIdentifier;
    private final String componentDisplayName;
    private final PublishArtifact publishArtifact;

    public PublishArtifactLocalArtifactMetaData(ComponentIdentifier componentIdentifier, String componentDisplayName, PublishArtifact publishArtifact) {
        this.componentIdentifier = componentIdentifier;
        this.componentDisplayName = componentDisplayName;
        this.publishArtifact = publishArtifact;
    }

    public String getDisplayName() {
        String extension;
        StringBuilder result = new StringBuilder();
        result.append(this.publishArtifact.getName());
        String classifier = this.publishArtifact.getClassifier();
        if (GUtil.isTrue((Object)classifier)) {
            result.append("-");
            result.append(classifier);
        }
        if (GUtil.isTrue((Object)(extension = this.publishArtifact.getExtension()))) {
            result.append(".");
            result.append(extension);
        }
        result.append(" (").append(this.componentDisplayName).append(")");
        return result.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public File getFile() {
        return this.publishArtifact.getFile();
    }

    public LocalComponentArtifactIdentifier getId() {
        return this;
    }

    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    public IvyArtifactName getName() {
        return DefaultIvyArtifactName.forPublishArtifact(this.publishArtifact);
    }

    public int hashCode() {
        return this.componentIdentifier.hashCode() ^ this.publishArtifact.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PublishArtifactLocalArtifactMetaData other = (PublishArtifactLocalArtifactMetaData)obj;
        return other.componentIdentifier.equals(this.componentIdentifier) && other.publishArtifact.equals(this.publishArtifact);
    }

    public TaskDependency getBuildDependencies() {
        return this.publishArtifact.getBuildDependencies();
    }
}

