/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;

public class BrowserCommandsMenu
extends JPopupMenu {
    private VFSBrowser browser;
    private HashMap<String, JRadioButtonMenuItem> encodingMenuItems;
    private JCheckBoxMenuItem autoDetect;
    private JRadioButtonMenuItem otherEncoding;

    public BrowserCommandsMenu(VFSBrowser vFSBrowser, VFSFile[] vFSFileArray) {
        Object object;
        this.browser = vFSBrowser;
        if (vFSFileArray != null) {
            object = VFSManager.getVFSForPath(vFSFileArray[0].getDeletePath());
            int n = vFSFileArray[0].getType();
            boolean bl = jEdit.getBuffer(vFSFileArray[0].getPath()) != null;
            int n2 = jEdit.getBuffer(vFSFileArray[0].getDeletePath()) != null ? 1 : 0;
            int n3 = n2 == 0 && (((VFS)object).getCapabilities() & 8) != 0 ? 1 : 0;
            boolean bl2 = !bl && (((VFS)object).getCapabilities() & 0x10) != 0;
            for (int i = 1; i < vFSFileArray.length; ++i) {
                VFSFile vFSFile = vFSFileArray[i];
                VFS vFS = VFSManager.getVFSForPath(vFSFile.getDeletePath());
                n3 &= object == vFS && (vFS.getCapabilities() & 8) != 0 ? 1 : 0;
                if (n != vFSFile.getType()) {
                    n = -1;
                }
                bl2 = false;
                if (jEdit.getBuffer(vFSFile.getPath()) == null) continue;
                bl = true;
            }
            if (n == 1 || n == 2) {
                if (vFSFileArray.length == 1) {
                    this.add(this.createMenuItem("browse"));
                }
                if (vFSBrowser.getMode() == 2) {
                    this.add(this.createMenuItem("browse-window"));
                }
            } else if (n == 0 && (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4)) {
                this.add(this.createMenuItem("open", "22x22/actions/document-open.png"));
                this.add(GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "vfs.browser.open-in"));
                if (vFSBrowser.getSelectedFiles().length == 1) {
                    this.add(this.createMenuItem("open-desktop", "22x22/actions/document-open.png"));
                    this.add(this.createMenuItem("insert"));
                }
                if (bl) {
                    this.add(this.createMenuItem("close"));
                }
            } else if (n != -1) {
                this.add(this.createMenuItem("open", "22x22/actions/document-open.png"));
            }
            if (bl2) {
                this.add(this.createMenuItem("rename"));
            }
            if (n3 != 0) {
                this.add(this.createMenuItem("delete", "22x22/actions/edit-delete.png"));
            }
            this.add(this.createMenuItem("copy-path", "22x22/actions/edit-copy.png"));
            this.add(this.createMenuItem("paste", "22x22/actions/edit-paste.png"));
            if (vFSFileArray.length == 1 || vFSBrowser.getSelectedFiles().length != 0) {
                this.add(this.createMenuItem("properties", "22x22/actions/document-properties.png"));
            }
            this.addSeparator();
        }
        this.add(this.createMenuItem("up", "22x22/actions/go-parent.png"));
        this.add(this.createMenuItem("previous", "22x22/actions/go-previous.png"));
        this.add(this.createMenuItem("next", "22x22/actions/go-next.png"));
        this.add(this.createMenuItem("reload", "22x22/actions/document-reload.png"));
        this.add(this.createMenuItem("roots"));
        this.add(this.createMenuItem("home", "22x22/actions/go-home.png"));
        this.add(this.createMenuItem("synchronize"));
        this.addSeparator();
        if (vFSBrowser.getMode() == 2) {
            this.add(this.createMenuItem("new-file", "22x22/actions/document-new.png"));
        }
        this.add(this.createMenuItem("new-directory", "22x22/actions/folder-new.png"));
        if (vFSBrowser.getMode() == 2) {
            this.addSeparator();
            this.add(this.createMenuItem("search-directory", "22x22/actions/system-search.png"));
        }
        this.addSeparator();
        this.add(this.createMenuItem("show-hidden-files"));
        if (vFSBrowser.getMode() == 2 || vFSBrowser.getMode() == 4) {
            this.addSeparator();
            this.add(this.createEncodingMenu());
        }
        if ((object = this.createCustomMenu()) != null) {
            Component[] componentArray;
            this.addSeparator();
            for (Component component : componentArray = ((JMenu)object).getMenuComponents()) {
                this.add((JMenuItem)component);
            }
        }
        this.addSeparator();
        this.add(this.createPluginMenu(vFSBrowser));
        this.update();
    }

    public void update() {
        if (this.encodingMenuItems != null && this.browser.currentEncoding != null) {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.encodingMenuItems.get(this.browser.currentEncoding);
            if (jRadioButtonMenuItem != null) {
                jRadioButtonMenuItem.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding.label"));
            } else {
                this.otherEncoding.setSelected(true);
                this.otherEncoding.setText(jEdit.getProperty("vfs.browser.other-encoding-2.label", new String[]{this.browser.currentEncoding}));
            }
        }
    }

    private JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), "vfs.browser." + string, false);
        jMenuItem.setIcon(GUIUtilities.loadIcon(string2));
        return jMenuItem;
    }

    private JMenuItem createMenuItem(String string) {
        return this.createMenuItem(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private JMenu createEncodingMenu() {
        JMenuItem jMenuItem;
        void var9_13;
        String[] stringArray;
        JMenu jMenu;
        ActionHandler actionHandler = new ActionHandler();
        this.encodingMenuItems = new HashMap();
        JMenuItem jMenuItem2 = jMenu = new JMenu(jEdit.getProperty("vfs.browser.commands.encoding.label"));
        this.autoDetect = new JCheckBoxMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        this.autoDetect.setSelected(this.browser.autoDetectEncoding);
        this.autoDetect.setActionCommand("auto-detect");
        this.autoDetect.addActionListener(actionHandler);
        jMenuItem2.add(this.autoDetect);
        jMenuItem2.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<JRadioButtonMenuItem> arrayList = new ArrayList<JRadioButtonMenuItem>();
        String[] object = stringArray = MiscUtilities.getEncodings(true);
        int jRadioButtonMenuItem = object.length;
        boolean jMenuItem3 = false;
        while (var9_13 < jRadioButtonMenuItem) {
            String string = object[var9_13];
            jMenuItem = new JRadioButtonMenuItem(string);
            jMenuItem.setActionCommand("encoding@" + string);
            jMenuItem.addActionListener(actionHandler);
            buttonGroup.add(jMenuItem);
            this.encodingMenuItems.put(string, (JRadioButtonMenuItem)jMenuItem);
            arrayList.add((JRadioButtonMenuItem)jMenuItem);
            ++var9_13;
        }
        String string = System.getProperty("file.encoding");
        if (this.encodingMenuItems.get(string) == null) {
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(string);
            jRadioButtonMenuItem2.setActionCommand("encoding@" + string);
            jRadioButtonMenuItem2.addActionListener(actionHandler);
            buttonGroup.add(jRadioButtonMenuItem2);
            this.encodingMenuItems.put(string, jRadioButtonMenuItem2);
            arrayList.add(jRadioButtonMenuItem2);
        }
        Collections.sort(arrayList, new MenuItemTextComparator());
        for (JMenuItem jMenuItem4 : arrayList) {
            JRadioButtonMenuItem jRadioButtonMenuItem3 = (JRadioButtonMenuItem)jMenuItem4;
            if (jMenuItem2.getMenuComponentCount() > 20) {
                jMenuItem = new JMenu(jEdit.getProperty("common.more"));
                jMenuItem2.add(jMenuItem);
                jMenuItem2 = jMenuItem;
            }
            jMenuItem2.add(jRadioButtonMenuItem3);
        }
        jMenuItem2.addSeparator();
        this.otherEncoding = new JRadioButtonMenuItem();
        this.otherEncoding.setActionCommand("other-encoding");
        this.otherEncoding.addActionListener(actionHandler);
        buttonGroup.add(this.otherEncoding);
        jMenuItem2.add(this.otherEncoding);
        return jMenu;
    }

    private JMenu createCustomMenu() {
        if (jEdit.getProperty("browser.custom.context", "").length() != 0) {
            JMenu jMenu = GUIUtilities.loadMenu(VFSBrowser.getActionContext(), "browser.custom.context");
            return jMenu;
        }
        return null;
    }

    private JMenu createPluginMenu(VFSBrowser vFSBrowser) {
        JMenu jMenu = new JMenu(jEdit.getProperty("vfs.browser.plugins.label"));
        GUIUtilities.setAutoMnemonic(jMenu);
        return (JMenu)vFSBrowser.createPluginsMenu(jMenu, false);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("auto-detect")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.autoDetectEncoding = BrowserCommandsMenu.this.autoDetect.isSelected();
            } else if (string.equals("other-encoding")) {
                String string2 = GUIUtilities.input(BrowserCommandsMenu.this.browser, "encoding-prompt", null, jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
                if (string2 == null) {
                    return;
                }
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = string2;
            } else if (string.startsWith("encoding@")) {
                ((BrowserCommandsMenu)BrowserCommandsMenu.this).browser.currentEncoding = string.substring(9);
            }
        }
    }
}

