/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.jedit.options.OptionGroupPane;

public class TabbedOptionDialog
extends EnhancedDialog
implements ActionListener,
ChangeListener {
    JTabbedPane tabs;
    LinkedList<OptionPane> panes;
    Set<OptionPane> shownPanes;
    private JButton ok;
    private JButton cancel;
    private JButton apply;

    public TabbedOptionDialog(Frame frame, String string) {
        super(frame, jEdit.getProperty(string + ".title"), true);
        this.setName(string);
        this.setupTabs();
    }

    public TabbedOptionDialog(Dialog dialog, String string) {
        super(dialog, jEdit.getProperty(string + ".title"), true);
        this.setName(string);
        this.setupTabs();
    }

    public void setSelectedIndex(int n) {
        this.tabs.setSelectedIndex(n);
    }

    void setupTabs() {
        this.panes = new LinkedList();
        this.shownPanes = new HashSet<OptionPane>();
        this.tabs = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.add((Component)this.tabs, "Center");
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        box.add(this.cancel);
        box.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(jEdit.getProperty("common.apply"));
        this.apply.addActionListener(this);
        box.add(this.apply);
        box.add(Box.createGlue());
        jPanel.add((Component)box, "South");
        this.setContentPane(jPanel);
        GUIUtilities.loadGeometry(this, this.getName());
        this.tabs.addChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.apply) {
            this.ok(false);
        }
    }

    public void addOptionPane(OptionPane optionPane) {
        this.panes.add(optionPane);
        JPanel jPanel = (JPanel)((Object)optionPane);
        this.tabs.addTab(optionPane.getName(), jPanel);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        OptionGroupPane optionGroupPane = new OptionGroupPane(optionGroup);
        optionGroupPane.addTextListener(new TitleChanger());
        this.addOptionPane(optionGroupPane);
    }

    @Override
    public void ok() {
        this.ok(true);
    }

    public void ok(boolean bl) {
        GUIUtilities.saveGeometry(this, this.getName());
        for (OptionPane optionPane : this.panes) {
            if (!this.shownPanes.contains(optionPane)) continue;
            optionPane.save();
        }
        Point point = this.getLocation();
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        if (bl) {
            this.dispose();
        }
    }

    @Override
    public void cancel() {
        GUIUtilities.saveGeometry(this, this.getName());
        this.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        OptionPane optionPane = (OptionPane)((Object)this.tabs.getSelectedComponent());
        this.shownPanes.add(optionPane);
        jEdit.setIntegerProperty("optional.last.tab", this.tabs.getSelectedIndex());
        this.setTitle(optionPane.getName());
    }

    class TitleChanger
    implements TextListener {
        TitleChanger() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TabbedOptionDialog.this.setTitle(textEvent.getSource().toString());
        }
    }
}

