/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderJob;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;

public abstract class JCSCachedTileLoaderJob<K, V extends CacheEntry>
implements ICachedLoaderJob<K> {
    private static final Logger log = FeatureAdapter.getLogger(JCSCachedTileLoaderJob.class.getCanonicalName());
    protected static final long DEFAULT_EXPIRE_TIME = 604800000L;
    protected static final long EXPIRE_TIME_SERVER_LIMIT = 2419200000L;
    protected static final long ABSOLUTE_EXPIRE_TIME_LIMIT = 31536000000L;
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("cache.jcs.max_threads", 10);
    private static final ThreadPoolExecutor DEFAULT_DOWNLOAD_JOB_DISPATCHER = new ThreadPoolExecutor(1, (int)THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Utils.newThreadFactory("JCS-downloader-%d", 5));
    private static final ConcurrentMap<String, Set<ICachedLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<ICachedLoaderListener>>();
    private static final ConcurrentMap<String, Boolean> useHead = new ConcurrentHashMap<String, Boolean>();
    protected final long now;
    private final ICacheAccess<K, V> cache;
    private ICacheElement<K, V> cacheElement;
    protected V cacheData;
    protected CacheEntryAttributes attributes;
    private final int connectTimeout;
    private final int readTimeout;
    private final Map<String, String> headers;
    private final ThreadPoolExecutor downloadJobExecutor;
    private Runnable finishTask;
    private boolean force;

    public JCSCachedTileLoaderJob(ICacheAccess<K, V> iCacheAccess, int n, int n2, Map<String, String> map, ThreadPoolExecutor threadPoolExecutor) {
        this.cache = iCacheAccess;
        this.now = System.currentTimeMillis();
        this.connectTimeout = n;
        this.readTimeout = n2;
        this.headers = map;
        this.downloadJobExecutor = threadPoolExecutor;
    }

    public JCSCachedTileLoaderJob(ICacheAccess<K, V> iCacheAccess, int n, int n2, Map<String, String> map) {
        this(iCacheAccess, n, n2, map, DEFAULT_DOWNLOAD_JOB_DISPATCHER);
    }

    private void ensureCacheElement() {
        if (this.cacheElement == null && this.getCacheKey() != null) {
            this.cacheElement = this.cache.getCacheElement(this.getCacheKey());
            if (this.cacheElement != null) {
                this.attributes = (CacheEntryAttributes)this.cacheElement.getElementAttributes();
                this.cacheData = (CacheEntry)this.cacheElement.getVal();
            }
        }
    }

    public V get() {
        this.ensureCacheElement();
        return this.cacheData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ICachedLoaderListener iCachedLoaderListener, boolean bl) throws IOException {
        this.force = bl;
        boolean bl2 = false;
        URL uRL = this.getUrl();
        String string = null;
        if (uRL != null) {
            string = uRL.toString();
        }
        if (string == null) {
            log.log(Level.WARNING, "No url returned for: {0}, skipping", this.getCacheKey());
            throw new IllegalArgumentException("No url returned");
        }
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            HashSet<ICachedLoaderListener> hashSet = (HashSet<ICachedLoaderListener>)inProgress.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<ICachedLoaderListener>();
                inProgress.put(string, hashSet);
                bl2 = true;
            }
            hashSet.add(iCachedLoaderListener);
        }
        if (bl2 || bl) {
            log.log(Level.FINE, "JCS - Submitting job for execution for url: {0}", this.getUrlNoException());
            this.downloadJobExecutor.execute(this);
        }
    }

    protected void executionFinished() {
        if (this.finishTask != null) {
            this.finishTask.run();
        }
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        byte[] byArray = ((CacheEntry)this.cacheData).getContent();
        return byArray != null && byArray.length > 0;
    }

    protected boolean cacheAsEmpty() {
        return this.attributes.getResponseCode() < 500;
    }

    protected String getServerKey() {
        return this.getUrlNoException().getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        thread.setName("JCS Downloading: " + this.getUrlNoException());
        log.log(Level.FINE, "JCS - starting fetch of url: {0} ", this.getUrlNoException());
        this.ensureCacheElement();
        try {
            if (!this.force && this.cacheElement != null && this.isCacheElementValid() && this.isObjectLoadable()) {
                log.log(Level.FINE, "JCS - Returning object from cache: {0}", this.getCacheKey());
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                return;
            }
            if (this.loadObject()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
            } else if (this.isObjectLoadable()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                log.log(Level.FINE, "JCS - found stale object in cache: {0}", this.getUrlNoException());
            } else {
                this.finishLoading(ICachedLoaderListener.LoadResult.FAILURE);
            }
        }
        finally {
            this.executionFinished();
            thread.setName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLoading(ICachedLoaderListener.LoadResult loadResult) {
        Set set;
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            set = (Set)inProgress.remove(this.getUrlNoException().toString());
        }
        if (set == null) {
            log.log(Level.WARNING, "Listener not found for URL: {0}. Listener not notified!", this.getUrlNoException());
            return;
        }
        for (ICachedLoaderListener iCachedLoaderListener : set) {
            iCachedLoaderListener.loadingFinished((CacheEntry)this.cacheData, this.attributes, loadResult);
        }
    }

    protected boolean isCacheElementValid() {
        long l = this.attributes.getExpirationTime();
        if (l != 0L) {
            if (this.now > (l = Math.min(l, this.attributes.getCreateTime() + 2419200000L))) {
                log.log(Level.FINE, "JCS - Object {0} has expired -> valid to {1}, now is: {2}", new Object[]{this.getUrlNoException(), Long.toString(l), Long.toString(this.now)});
                return false;
            }
        } else {
            if (this.attributes.getLastModification() > 0L && this.now - this.attributes.getLastModification() > 604800000L) {
                log.log(Level.FINE, "JCS - Object has expired, maximum file age reached {0}", this.getUrlNoException());
                return false;
            }
            if (this.now - this.attributes.getCreateTime() > 604800000L) {
                log.log(Level.FINE, "JCS - Object has expired, maximum time since object creation reached {0}", this.getUrlNoException());
                return false;
            }
        }
        return true;
    }

    private boolean loadObject() {
        if (this.attributes == null) {
            this.attributes = new CacheEntryAttributes();
        }
        try {
            HttpClient.Response response;
            if (this.isObjectLoadable() && Boolean.TRUE.equals(useHead.get(this.getServerKey())) && this.isCacheValidUsingHead()) {
                log.log(Level.FINE, "JCS - cache entry verified using HEAD request: {0}", this.getUrl());
                return true;
            }
            HttpClient httpClient = this.getRequest("GET", true);
            if (this.isObjectLoadable() && this.now - this.attributes.getLastModification() <= 31536000000L) {
                httpClient.setIfModifiedSince(this.attributes.getLastModification());
            }
            if (this.isObjectLoadable() && this.attributes.getEtag() != null) {
                httpClient.setHeader("If-None-Match", this.attributes.getEtag());
            }
            if ((response = httpClient.connect()).getResponseCode() == 304) {
                log.log(Level.FINE, "JCS - If-Modified-Since/ETag test: local version is up to date: {0}", this.getUrl());
                return true;
            }
            if (this.isObjectLoadable() && (this.attributes.getEtag() != null && this.attributes.getEtag().equals(response.getHeaderField("ETag")) || this.attributes.getLastModification() == response.getLastModified())) {
                String string = this.getServerKey();
                log.log(Level.INFO, "JCS - Host: {0} found not to return 304 codes for If-Modified-Since or If-None-Match headers", string);
                useHead.put(string, Boolean.TRUE);
            }
            this.attributes = this.parseHeaders(response);
            for (int i = 0; i < 5; ++i) {
                if (response.getResponseCode() != 503) {
                    this.attributes.setResponseCode(response.getResponseCode());
                    byte[] byArray = response.getResponseCode() == 200 ? Utils.readBytesFromStream(response.getContent()) : new byte[]{};
                    if (this.isResponseLoadable(response.getHeaderFields(), response.getResponseCode(), byArray)) {
                        this.cacheData = this.createCacheEntry(byArray);
                        this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                        log.log(Level.FINE, "JCS - downloaded key: {0}, length: {1}, url: {2}", new Object[]{this.getCacheKey(), byArray.length, this.getUrl()});
                        return true;
                    }
                    if (this.cacheAsEmpty()) {
                        this.cacheData = this.createCacheEntry(new byte[0]);
                        this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                        log.log(Level.FINE, "JCS - Caching empty object {0}", this.getUrl());
                        return true;
                    }
                    log.log(Level.FINE, "JCS - failure during load - reponse is not loadable nor cached as empty");
                    return false;
                }
                Thread.sleep(5000L + (long)new SecureRandom().nextInt(5000));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl;
            log.log(Level.FINE, "JCS - Caching empty object as server returned 404 for: {0}", this.getUrlNoException());
            this.attributes.setResponseCode(404);
            this.attributes.setError(fileNotFoundException);
            boolean bl2 = bl = this.isResponseLoadable(null, 404, null) || this.cacheAsEmpty();
            if (bl) {
                this.cacheData = this.createCacheEntry(new byte[0]);
                this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
            }
            return bl;
        }
        catch (IOException iOException) {
            boolean bl;
            log.log(Level.FINE, "JCS - IOExecption during communication with server for: {0}", this.getUrlNoException());
            this.attributes.setError(iOException);
            this.attributes.setResponseCode(499);
            boolean bl3 = bl = this.isResponseLoadable(null, 499, null) || this.cacheAsEmpty();
            if (bl) {
                this.cacheData = this.createCacheEntry(new byte[0]);
                this.cache.put(this.getCacheKey(), this.createCacheEntry(new byte[0]), this.attributes);
            }
            return bl;
        }
        catch (InterruptedException interruptedException) {
            this.attributes.setError(interruptedException);
            log.log(Level.WARNING, "JCS - Exception during download {0}", this.getUrlNoException());
            Main.warn(interruptedException);
        }
        log.log(Level.WARNING, "JCS - Silent failure during download: {0}", this.getUrlNoException());
        return false;
    }

    protected boolean isResponseLoadable(Map<String, List<String>> map, int n, byte[] byArray) {
        return byArray != null && byArray.length != 0 && n < 400;
    }

    protected abstract V createCacheEntry(byte[] var1);

    protected CacheEntryAttributes parseHeaders(HttpClient.Response response) {
        Long l;
        CacheEntryAttributes cacheEntryAttributes;
        block5: {
            cacheEntryAttributes = new CacheEntryAttributes();
            l = response.getExpiration();
            if (l.equals(0L)) {
                try {
                    String string = response.getHeaderField("Cache-Control");
                    if (string != null) {
                        for (String string2 : string.split(",")) {
                            if (!string2.startsWith("max-age=")) continue;
                            l = Long.parseLong(string2.substring(8)) * 1000L + System.currentTimeMillis();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!Main.isTraceEnabled()) break block5;
                    Main.trace(numberFormatException.getMessage());
                }
            }
        }
        cacheEntryAttributes.setExpirationTime(l);
        cacheEntryAttributes.setLastModification(this.now);
        cacheEntryAttributes.setEtag(response.getHeaderField("ETag"));
        return cacheEntryAttributes;
    }

    private HttpClient getRequest(String string, boolean bl) throws IOException {
        HttpClient httpClient = HttpClient.create(this.getUrl(), string);
        httpClient.setAccept("text/html, image/png, image/jpeg, image/gif, */*");
        httpClient.setReadTimeout(this.readTimeout);
        httpClient.setConnectTimeout(this.connectTimeout);
        if (this.headers != null) {
            httpClient.setHeaders(this.headers);
        }
        if (this.force || bl) {
            httpClient.useCache(false);
        }
        return httpClient;
    }

    private boolean isCacheValidUsingHead() throws IOException {
        HttpClient.Response response = this.getRequest("HEAD", false).connect();
        long l = response.getLastModified();
        return this.attributes.getEtag() != null && this.attributes.getEtag().equals(response.getHeaderField("ETag")) || l != 0L && l <= this.attributes.getLastModification();
    }

    public void cancelOutstandingTasks() {
        for (Runnable runnable : this.downloadJobExecutor.getQueue()) {
            if (!this.downloadJobExecutor.remove(runnable) || !(runnable instanceof JCSCachedTileLoaderJob)) continue;
            ((JCSCachedTileLoaderJob)runnable).handleJobCancellation();
        }
    }

    public void setFinishedTask(Runnable runnable) {
        this.finishTask = runnable;
    }

    public void handleJobCancellation() {
        this.finishLoading(ICachedLoaderListener.LoadResult.CANCELED);
    }

    private URL getUrlNoException() {
        try {
            return this.getUrl();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

