/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.util.CursorManager;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class NavigatableComponent
extends JComponent
implements Helpful {
    public transient Predicate<OsmPrimitive> isSelectablePredicate = new Predicate<OsmPrimitive>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.isSelectable()) {
                return false;
            }
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                boolean bl = !MapPaintStyles.getStyles().get(osmPrimitive, NavigatableComponent.this.getDist100Pixel(), NavigatableComponent.this).isEmpty();
                return bl;
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
        }
    };
    public static final IntegerProperty PROP_SNAP_DISTANCE = new IntegerProperty("mappaint.node.snap-distance", 10);
    public static final DoubleProperty PROP_ZOOM_RATIO = new DoubleProperty("zoom.ratio", 2.0);
    public static final BooleanProperty PROP_ZOOM_INTERMEDIATE_STEPS = new BooleanProperty("zoom.intermediate-steps", true);
    public static final String PROPNAME_CENTER = "center";
    public static final String PROPNAME_SCALE = "scale";
    private transient NativeScaleLayer nativeScaleLayer;
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    private final transient HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            long l = 1405L;
            if ((hierarchyEvent.getChangeFlags() & l) != 0L) {
                NavigatableComponent.this.updateLocationState();
            }
        }
    };
    private final transient ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            NavigatableComponent.this.updateLocationState();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            NavigatableComponent.this.updateLocationState();
        }
    };
    protected transient ViewportData initialViewport;
    protected final transient CursorManager cursorManager = new CursorManager(this);
    private transient MapViewState state;
    private final transient Stack<ZoomData> zoomUndoBuffer = new Stack();
    private final transient Stack<ZoomData> zoomRedoBuffer = new Stack();
    private Date zoomTimestamp = new Date();

    public static void removeZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        zoomChangeListeners.remove(zoomChangeListener);
    }

    public static void addZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        if (zoomChangeListener != null) {
            zoomChangeListeners.addIfAbsent(zoomChangeListener);
        }
    }

    protected static void fireZoomChanged() {
        for (ZoomChangeListener zoomChangeListener : zoomChangeListeners) {
            zoomChangeListener.zoomChanged();
        }
    }

    public NavigatableComponent() {
        this.setLayout(null);
        this.state = MapViewState.createDefaultState(this.getWidth(), this.getHeight());
        Main.addProjectionChangeListener(new ProjectionChangeListener(){

            @Override
            public void projectionChanged(Projection projection, Projection projection2) {
                NavigatableComponent.this.fixProjection();
            }
        });
    }

    @Override
    public void addNotify() {
        this.updateLocationState();
        this.addHierarchyListener(this.hierarchyListener);
        this.addComponentListener(this.componentListener);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this.hierarchyListener);
        this.removeComponentListener(this.componentListener);
        super.removeNotify();
    }

    public void setNativeScaleLayer(NativeScaleLayer nativeScaleLayer) {
        this.nativeScaleLayer = nativeScaleLayer;
        this.zoomTo(this.getCenter(), this.scaleRound(this.getScale()));
        this.repaint();
    }

    public NativeScaleLayer getNativeScaleLayer() {
        return this.nativeScaleLayer;
    }

    public double scaleZoomIn() {
        return this.scaleZoomManyTimes(-1);
    }

    public double scaleZoomOut() {
        return this.scaleZoomManyTimes(1);
    }

    public double scaleZoomManyTimes(int n) {
        NativeScaleLayer.ScaleList scaleList;
        if (this.nativeScaleLayer != null && (scaleList = this.nativeScaleLayer.getNativeScales()) != null) {
            NativeScaleLayer.Scale scale;
            if (PROP_ZOOM_INTERMEDIATE_STEPS.get().booleanValue()) {
                scaleList = scaleList.withIntermediateSteps(PROP_ZOOM_RATIO.get());
            }
            return (scale = scaleList.scaleZoomTimes(this.getScale(), PROP_ZOOM_RATIO.get(), n)) != null ? scale.getScale() : 0.0;
        }
        return this.getScale() * Math.pow(PROP_ZOOM_RATIO.get(), n);
    }

    public double scaleRound(double d) {
        return this.scaleSnap(d, false);
    }

    public double scaleFloor(double d) {
        return this.scaleSnap(d, true);
    }

    public double scaleSnap(double d, boolean bl) {
        NativeScaleLayer.ScaleList scaleList;
        if (this.nativeScaleLayer != null && (scaleList = this.nativeScaleLayer.getNativeScales()) != null) {
            NativeScaleLayer.Scale scale;
            if (PROP_ZOOM_INTERMEDIATE_STEPS.get().booleanValue()) {
                scaleList = scaleList.withIntermediateSteps(PROP_ZOOM_RATIO.get());
            }
            return (scale = scaleList.getSnapScale(d, PROP_ZOOM_RATIO.get(), bl)) != null ? scale.getScale() : d;
        }
        return d;
    }

    public void zoomIn() {
        this.zoomTo(this.getCenter(), this.scaleZoomIn());
    }

    public void zoomOut() {
        this.zoomTo(this.getCenter(), this.scaleZoomOut());
    }

    @Deprecated
    protected DataSet getCurrentDataSet() {
        return Main.getLayerManager().getEditDataSet();
    }

    protected void updateLocationState() {
        if (this.isVisibleOnScreen()) {
            this.state = this.state.usingLocation(this);
        }
    }

    protected boolean isVisibleOnScreen() {
        return SwingUtilities.getWindowAncestor(this) != null && this.isShowing();
    }

    public void fixProjection() {
        this.state = this.state.usingProjection(Main.getProjection());
        this.repaint();
    }

    public MapViewState getState() {
        return this.state;
    }

    public static String getDistText(double d) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText(d);
    }

    public static String getDistText(double d, NumberFormat numberFormat, double d2) {
        return SystemOfMeasurement.getSystemOfMeasurement().getDistText(d, numberFormat, d2);
    }

    public String getDist100PixelText() {
        return NavigatableComponent.getDistText(this.getDist100Pixel());
    }

    public double getDist100Pixel() {
        return this.getDist100Pixel(true);
    }

    public double getDist100Pixel(boolean bl) {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        LatLon latLon = this.getLatLon(n - 50, n2);
        LatLon latLon2 = this.getLatLon(n + 50, n2);
        double d = latLon.greatCircleDistance(latLon2);
        if (bl && d <= 0.0) {
            return 0.1;
        }
        return d;
    }

    public EastNorth getCenter() {
        return this.state.getCenter().getEastNorth();
    }

    public double getScale() {
        return this.state.getScale();
    }

    public EastNorth getEastNorth(int n, int n2) {
        return this.state.getForView(n, n2).getEastNorth();
    }

    public ProjectionBounds getProjectionBounds() {
        return this.getState().getViewArea().getProjectionBounds();
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax()));
    }

    public Bounds getRealBounds() {
        return this.getState().getViewArea().getCornerBounds();
    }

    public LatLon getLatLon(int n, int n2) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(n, n2));
    }

    public LatLon getLatLon(double d, double d2) {
        return this.getLatLon((int)d, (int)d2);
    }

    public ProjectionBounds getProjectionBounds(Rectangle rectangle) {
        return this.getState().getViewArea(rectangle).getProjectionBounds();
    }

    public Bounds getLatLonBounds(Rectangle rectangle) {
        return Main.getProjection().getLatLonBoundsBox(this.getProjectionBounds(rectangle));
    }

    public AffineTransform getAffineTransform() {
        return this.getState().getAffineTransform();
    }

    public Point2D getPoint2D(EastNorth eastNorth) {
        if (null == eastNorth) {
            return new Point();
        }
        return this.getState().getPointFor(eastNorth).getInView();
    }

    public Point2D getPoint2D(LatLon latLon) {
        if (latLon == null) {
            return new Point();
        }
        if (latLon instanceof CachedLatLon) {
            return this.getPoint2D(((CachedLatLon)latLon).getEastNorth());
        }
        return this.getPoint2D(this.getProjection().latlon2eastNorth(latLon));
    }

    public Point2D getPoint2D(Node node) {
        return this.getPoint2D(node.getEastNorth());
    }

    public Point getPoint(EastNorth eastNorth) {
        Point2D point2D = this.getPoint2D(eastNorth);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public Point getPoint(LatLon latLon) {
        Point2D point2D = this.getPoint2D(latLon);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public Point getPoint(Node node) {
        Point2D point2D = this.getPoint2D(node);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public void zoomTo(EastNorth eastNorth, double d) {
        this.zoomTo(eastNorth, d, false);
    }

    public void zoomTo(EastNorth eastNorth, double d, boolean bl) {
        double d2;
        double d3;
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        ProjectionBounds projectionBounds = this.getProjection().getWorldBoundsBoxEastNorth();
        int n = this.getWidth();
        int n2 = this.getHeight();
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        d4 = Math.max(d4, projectionBounds.minEast);
        d4 = Math.min(d4, projectionBounds.maxEast);
        d5 = Math.max(d5, projectionBounds.minNorth);
        d5 = Math.min(d5, projectionBounds.maxNorth);
        eastNorth = new EastNorth(d4, d5);
        double d6 = projectionBounds.maxNorth - projectionBounds.minNorth;
        if (n2 > 0 && 2.0 * d6 < (double)n2 * d) {
            double d7 = 2.0 * d6 / (double)n2;
            d3 = projectionBounds.maxEast - projectionBounds.minEast;
            if (n > 0 && 2.0 * d3 < (double)n * d) {
                d2 = 2.0 * d3 / (double)n;
                d = Math.max(d7, d2);
            }
        }
        LatLon latLon = this.getLatLon(n / 2 - 50, n2 / 2);
        LatLon latLon2 = this.getLatLon(n / 2 + 50, n2 / 2);
        if (latLon.isValid() && latLon2.isValid() && bounds.contains(latLon) && bounds.contains(latLon2)) {
            d3 = latLon.greatCircleDistance(latLon2);
            d2 = 100.0 * this.getScale();
            double d8 = 0.01 * d2 / d3 / 100.0;
            if (!Double.isInfinite(d8) && d < d8) {
                d = d8;
            }
        }
        d = this.scaleRound(d);
        if (!eastNorth.equals(this.getCenter()) || !Utils.equalsEpsilon(this.getScale(), d)) {
            if (!bl) {
                this.pushZoomUndo(this.getCenter(), this.getScale());
            }
            this.zoomNoUndoTo(eastNorth, d, bl);
        }
    }

    private void zoomNoUndoTo(EastNorth eastNorth, double d, boolean bl) {
        if (!eastNorth.equals(this.getCenter())) {
            EastNorth eastNorth2 = this.getCenter();
            this.state = this.state.usingCenter(eastNorth);
            if (!bl) {
                this.firePropertyChange(PROPNAME_CENTER, eastNorth2, eastNorth);
            }
        }
        if (!Utils.equalsEpsilon(this.getScale(), d)) {
            double d2 = this.getScale();
            this.state = this.state.usingScale(d);
            this.state = this.state.movedTo(this.state.getCenter(), eastNorth);
            if (!bl) {
                this.firePropertyChange(PROPNAME_SCALE, d2, d);
            }
        }
        if (!bl) {
            this.repaint();
            NavigatableComponent.fireZoomChanged();
        }
    }

    public void zoomTo(EastNorth eastNorth) {
        this.zoomTo(eastNorth, this.getScale());
    }

    public void zoomTo(LatLon latLon) {
        this.zoomTo(Projections.project(latLon));
    }

    public void smoothScrollTo(EastNorth eastNorth) {
        if (!eastNorth.equals(this.getCenter())) {
            final EastNorth eastNorth2 = this.getCenter();
            double d = eastNorth.distance(eastNorth2) / this.getScale();
            double d2 = d / (double)this.getWidth() * 1500.0;
            final double d3 = d2 * 20.0 / 1000.0;
            final EastNorth eastNorth3 = eastNorth;
            new Thread("smooth-scroller"){

                @Override
                public void run() {
                    int n = 0;
                    while ((double)n < d3) {
                        NavigatableComponent.this.zoomTo(eastNorth2.interpolate(eastNorth3, (double)(n + 1) / d3));
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            Main.warn("InterruptedException in " + NavigatableComponent.class.getSimpleName() + " during smooth scrolling");
                        }
                        ++n;
                    }
                }
            }.start();
        }
    }

    public void zoomManyTimes(double d, double d2, int n) {
        double d3 = this.getScale();
        double d4 = this.scaleZoomManyTimes(n);
        this.zoomToFactor(d, d2, d4 / d3);
    }

    public void zoomToFactor(double d, double d2, double d3) {
        double d4 = this.getScale() * d3;
        EastNorth eastNorth = this.getState().getForView(d, d2).getEastNorth();
        MapViewState mapViewState = this.getState().usingScale(d4);
        mapViewState = mapViewState.movedTo(mapViewState.getForView(d, d2), eastNorth);
        this.zoomTo(mapViewState.getCenter().getEastNorth(), d4);
    }

    public void zoomToFactor(EastNorth eastNorth, double d) {
        this.zoomTo(eastNorth, this.getScale() * d);
    }

    public void zoomToFactor(double d) {
        this.zoomTo(this.getCenter(), this.getScale() * d);
    }

    public void zoomTo(ProjectionBounds projectionBounds) {
        int n;
        int n2 = this.getWidth() - 20;
        if (n2 < 20) {
            n2 = 20;
        }
        if ((n = this.getHeight() - 20) < 20) {
            n = 20;
        }
        double d = (projectionBounds.maxEast - projectionBounds.minEast) / (double)n2;
        double d2 = (projectionBounds.maxNorth - projectionBounds.minNorth) / (double)n;
        double d3 = Math.max(d, d2);
        d3 = this.scaleFloor(d3);
        this.zoomTo(projectionBounds.getCenter(), d3);
    }

    public void zoomTo(Bounds bounds) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(bounds.getMin()), this.getProjection().latlon2eastNorth(bounds.getMax())));
    }

    public void zoomTo(ViewportData viewportData) {
        if (viewportData == null) {
            return;
        }
        if (viewportData.getBounds() != null) {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            boundingXYVisitor.visit(viewportData.getBounds());
            this.zoomTo(boundingXYVisitor);
        } else {
            this.zoomTo(viewportData.getCenter(), viewportData.getScale(), true);
        }
    }

    public void zoomTo(BoundingXYVisitor boundingXYVisitor) {
        if (boundingXYVisitor == null) {
            boundingXYVisitor = new BoundingXYVisitor();
        }
        if (boundingXYVisitor.getBounds() == null) {
            boundingXYVisitor.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!boundingXYVisitor.hasExtend()) {
            boundingXYVisitor.enlargeBoundingBox();
        }
        this.zoomTo(boundingXYVisitor.getBounds());
    }

    private void pushZoomUndo(EastNorth eastNorth, double d) {
        Date date = new Date();
        if ((double)(date.getTime() - this.zoomTimestamp.getTime()) > Main.pref.getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(eastNorth, d));
            if (this.zoomUndoBuffer.size() > Main.pref.getInteger("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = date;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.getCenter(), this.getScale()));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale(), false);
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoomData = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.getCenter(), this.getScale()));
            this.zoomNoUndoTo(zoomData.getCenterEastNorth(), zoomData.getScale(), false);
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getBBox(Point point, int n) {
        return new BBox(this.getLatLon(point.x - n, point.y - n), this.getLatLon(point.x + n, point.y + n));
    }

    private Map<Double, List<Node>> getNearestNodesImpl(Point point, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<Node>> treeMap = new TreeMap<Double, List<Node>>();
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        if (dataSet != null) {
            double d = PROP_SNAP_DISTANCE.get().intValue();
            d *= d;
            for (Node node : dataSet.searchNodes(this.getBBox(point, PROP_SNAP_DISTANCE.get()))) {
                List<Node> list;
                double d2;
                if (!predicate.evaluate(node)) continue;
                double d3 = this.getPoint2D(node).distanceSq(point);
                if (!(d2 < d)) continue;
                if (treeMap.containsKey(d3)) {
                    list = (List)treeMap.get(d3);
                } else {
                    list = new LinkedList();
                    treeMap.put(d3, list);
                }
                list.add(node);
            }
        }
        return treeMap;
    }

    public final List<Node> getNearestNodes(Point point, Collection<Node> collection, Predicate<OsmPrimitive> predicate) {
        Map<Double, List<Node>> map;
        List<Node> list = Collections.emptyList();
        if (collection == null) {
            collection = Collections.emptySet();
        }
        if (!(map = this.getNearestNodesImpl(point, predicate)).isEmpty()) {
            Double d = null;
            for (Map.Entry<Double, List<Node>> entry : map.entrySet()) {
                Double d2 = entry.getKey();
                List<Node> list2 = entry.getValue();
                list2.removeAll(collection);
                if (d == null) {
                    if (list2.isEmpty()) continue;
                    d = d2;
                    list = new ArrayList<Node>();
                    list.addAll(list2);
                    continue;
                }
                if (!(d2 - d < 16.0)) continue;
                list.addAll(list2);
            }
        }
        return list;
    }

    public final List<Node> getNearestNodes(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodes(point, null, predicate);
    }

    public final Node getNearestNode(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        return this.getNearestNode(point, predicate, bl, null);
    }

    public final Node getNearestNode(Point point, Predicate<OsmPrimitive> predicate, boolean bl, Collection<OsmPrimitive> collection) {
        Map<Double, List<Node>> map = this.getNearestNodesImpl(point, predicate);
        if (map.isEmpty()) {
            return null;
        }
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        boolean bl2 = bl;
        double d = map.keySet().iterator().next();
        for (Map.Entry<Double, List<Node>> entry : map.entrySet()) {
            Double d2 = entry.getKey();
            for (Node node4 : entry.getValue()) {
                if (node == null && node4.isSelected()) {
                    node = node4;
                    bl2 |= Utils.equalsEpsilon(d2, d);
                }
                if (node3 == null && collection != null && Utils.equalsEpsilon(d2, d)) {
                    List<OsmPrimitive> list = node4.getReferrers();
                    for (OsmPrimitive osmPrimitive : collection) {
                        if (!list.contains(osmPrimitive)) continue;
                        node3 = node4;
                        break;
                    }
                }
                if (node2 != null || !node4.isNew() || !(d2 - d < 1.0)) continue;
                node2 = node4;
            }
        }
        if (node != null && bl2) {
            return node;
        }
        if (node3 != null) {
            return node3;
        }
        if (node2 != null) {
            return node2;
        }
        return map.values().iterator().next().get(0);
    }

    public final Node getNearestNode(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNode(point, predicate, true);
    }

    private Map<Double, List<WaySegment>> getNearestWaySegmentsImpl(Point point, Predicate<OsmPrimitive> predicate) {
        TreeMap<Double, List<WaySegment>> treeMap = new TreeMap<Double, List<WaySegment>>();
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        if (dataSet != null) {
            double d = Main.pref.getInteger("mappaint.segment.snap-distance", 10);
            d *= d;
            for (Way way : dataSet.searchWays(this.getBBox(point, Main.pref.getInteger("mappaint.segment.snap-distance", 10)))) {
                if (!predicate.evaluate(way)) continue;
                Node node = null;
                int n = -2;
                for (Node node2 : way.getNodes()) {
                    double d2;
                    ++n;
                    if (node2.isDeleted() || node2.isIncomplete()) continue;
                    if (node == null) {
                        node = node2;
                        continue;
                    }
                    Point2D point2D = this.getPoint2D(node);
                    Point2D point2D2 = this.getPoint2D(node2);
                    double d3 = point2D.distanceSq(point2D2);
                    double d4 = point.distanceSq(point2D2);
                    double d5 = Double.longBitsToDouble(Double.doubleToLongBits(d4 - (d4 - (d2 = point.distanceSq(point2D)) + d3) * (d4 - d2 + d3) / 4.0 / d3) >> 32 << 32);
                    if (d5 < d && d4 < d3 + d && d2 < d3 + d) {
                        List<WaySegment> list;
                        if (treeMap.containsKey(d5)) {
                            list = (List)treeMap.get(d5);
                        } else {
                            list = new LinkedList();
                            treeMap.put(d5, list);
                        }
                        list.add(new WaySegment(way, n));
                    }
                    node = node2;
                }
            }
        }
        return treeMap;
    }

    public final List<WaySegment> getNearestWaySegments(Point point, Collection<WaySegment> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<WaySegment> arrayList = new ArrayList<WaySegment>();
        LinkedList linkedList = new LinkedList();
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (WaySegment waySegment : list) {
                (waySegment.way.isSelected() ? arrayList : linkedList).add((WaySegment)waySegment);
            }
            arrayList.addAll(linkedList);
            linkedList.clear();
        }
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<WaySegment> getNearestWaySegments(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegments(point, null, predicate);
    }

    public final WaySegment getNearestWaySegment(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        WaySegment waySegment = null;
        WaySegment waySegment2 = null;
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            if (waySegment != null && waySegment2 != null) break;
            for (WaySegment waySegment3 : list) {
                if (waySegment == null) {
                    waySegment = waySegment3;
                }
                if (waySegment2 != null || !waySegment3.way.isSelected()) continue;
                waySegment2 = waySegment3;
            }
        }
        return waySegment2 != null && bl ? waySegment2 : waySegment;
    }

    public final WaySegment getNearestWaySegment(Point point, Predicate<OsmPrimitive> predicate, boolean bl, Collection<OsmPrimitive> collection) {
        WaySegment waySegment = null;
        WaySegment waySegment2 = null;
        WaySegment waySegment3 = null;
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        block0: for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (WaySegment waySegment4 : list) {
                if (waySegment == null) {
                    waySegment = waySegment4;
                }
                if (waySegment2 == null && waySegment4.way.isSelected()) {
                    waySegment2 = waySegment4;
                    break block0;
                }
                if (waySegment3 != null || collection == null) continue;
                for (Node node : waySegment4.way.getNodes()) {
                    if (!collection.contains(node)) continue;
                    waySegment3 = waySegment4;
                    break block0;
                }
                List<OsmPrimitive> list2 = waySegment4.way.getReferrers();
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!(osmPrimitive instanceof Relation) || !list2.contains(osmPrimitive)) continue;
                    waySegment3 = waySegment4;
                    break block0;
                }
            }
        }
        if (waySegment2 != null && bl) {
            return waySegment2;
        }
        if (waySegment3 != null) {
            return waySegment3;
        }
        return waySegment;
    }

    public final WaySegment getNearestWaySegment(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegment(point, predicate, true);
    }

    public final List<Way> getNearestWays(Point point, Collection<Way> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (List<WaySegment> list : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (WaySegment waySegment : list) {
                if (!hashSet.add(waySegment.way)) continue;
                arrayList.add(waySegment.way);
            }
        }
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<Way> getNearestWays(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWays(point, null, predicate);
    }

    public final Way getNearestWay(Point point, Predicate<OsmPrimitive> predicate) {
        WaySegment waySegment = this.getNearestWaySegment(point, predicate);
        return waySegment == null ? null : waySegment.way;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point point, Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        List<OsmPrimitive> list = Collections.emptyList();
        OsmPrimitive osmPrimitive = this.getNearestNodeOrWay(point, predicate, false);
        if (osmPrimitive != null) {
            if (osmPrimitive instanceof Node) {
                list = new ArrayList<Node>(this.getNearestNodes(point, predicate));
            } else if (osmPrimitive instanceof Way) {
                list = new ArrayList<Way>(this.getNearestWays(point, predicate));
            }
            if (collection != null) {
                list.removeAll(collection);
            }
        }
        return list;
    }

    public final List<OsmPrimitive> getNearestNodesOrWays(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getNearestNodesOrWays(point, null, predicate);
    }

    private boolean isPrecedenceNode(Node node, Point point, boolean bl) {
        if (node != null) {
            if (point.distanceSq(this.getPoint2D(node)) <= 16.0) {
                return true;
            }
            if (node.isTagged()) {
                return true;
            }
            if (bl && node.isSelected()) {
                return true;
            }
        }
        return false;
    }

    public final OsmPrimitive getNearestNodeOrWay(Point point, Predicate<OsmPrimitive> predicate, boolean bl) {
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        Collection<OsmPrimitive> collection = bl && dataSet != null ? dataSet.getSelected() : null;
        OsmPrimitive osmPrimitive = this.getNearestNode(point, predicate, bl, collection);
        if (this.isPrecedenceNode((Node)osmPrimitive, point, bl)) {
            return osmPrimitive;
        }
        WaySegment waySegment = bl ? this.getNearestWaySegment(point, predicate, bl, collection) : this.getNearestWaySegment(point, predicate, bl);
        if (waySegment == null) {
            return osmPrimitive;
        }
        if (waySegment.way.isSelected() && bl || osmPrimitive == null) {
            osmPrimitive = waySegment.way;
        } else {
            Point2D point2D;
            int n = 3 * PROP_SNAP_DISTANCE.get();
            n *= n;
            Point2D point2D2 = this.getPoint2D(waySegment.way.getNode(waySegment.lowerIndex));
            if (point2D2.distanceSq(point2D = this.getPoint2D(waySegment.way.getNode(waySegment.lowerIndex + 1))) < (double)n && point.distanceSq(NavigatableComponent.project(0.5, point2D2, point2D)) < point.distanceSq(this.getPoint2D((Node)osmPrimitive))) {
                osmPrimitive = waySegment.way;
            }
        }
        return osmPrimitive;
    }

    public static Point2D project(double d, Point2D point2D, Point2D point2D2) {
        Point2D.Double double_ = null;
        if (point2D != null && point2D2 != null) {
            double_ = new Point2D.Double(point2D.getX() + d * (point2D2.getX() - point2D.getX()), point2D.getY() + d * (point2D2.getY() - point2D.getY()));
        }
        return double_;
    }

    public final List<OsmPrimitive> getAllNearest(Point point, Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (List<WaySegment> object : this.getNearestWaySegmentsImpl(point, predicate).values()) {
            for (Object object2 : object) {
                if (!hashSet.add(((WaySegment)object2).way)) continue;
                arrayList.add(((WaySegment)object2).way);
            }
        }
        for (List<Comparable<WaySegment>> list : this.getNearestNodesImpl(point, predicate).values()) {
            arrayList.addAll(list);
        }
        HashSet hashSet2 = new HashSet();
        for (OsmPrimitive osmPrimitive : arrayList) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || !predicate.evaluate(osmPrimitive2)) continue;
                hashSet2.add(osmPrimitive2);
            }
        }
        arrayList.addAll(hashSet2);
        if (collection != null) {
            arrayList.removeAll(collection);
        }
        return arrayList;
    }

    public final List<OsmPrimitive> getAllNearest(Point point, Predicate<OsmPrimitive> predicate) {
        return this.getAllNearest(point, null, predicate);
    }

    public Projection getProjection() {
        return this.state.getProjection();
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public int getViewID() {
        EastNorth eastNorth = this.getCenter();
        String string = "" + eastNorth.east() + '_' + eastNorth.north() + '_' + this.getScale() + '_' + this.getWidth() + '_' + this.getHeight() + '_' + this.getProjection();
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes(StandardCharsets.UTF_8));
        return (int)cRC32.getValue();
    }

    public void setNewCursor(Cursor cursor, Object object) {
        this.cursorManager.setNewCursor(cursor, object);
    }

    public void setNewCursor(int n, Object object) {
        this.setNewCursor(Cursor.getPredefinedCursor(n), object);
    }

    public void resetCursor(Object object) {
        this.cursorManager.resetCursor(object);
    }

    public CursorManager getCursorManager() {
        return this.cursorManager;
    }

    public double getMaxScale() {
        ProjectionBounds projectionBounds = this.getMaxProjectionBounds();
        return Math.max(projectionBounds.maxNorth - projectionBounds.minNorth, projectionBounds.maxEast - projectionBounds.minEast) / 512.0;
    }

    private static class ZoomData {
        private final EastNorth center;
        private final double scale;

        ZoomData(EastNorth eastNorth, double d) {
            this.center = eastNorth;
            this.scale = d;
        }

        public EastNorth getCenterEastNorth() {
            return this.center;
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

