/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class LoadObjectHandler
extends RequestHandler {
    public static final String command = "load_object";
    private final List<PrimitiveId> ps = new LinkedList<PrimitiveId>();

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"objects"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "layer_name", "addtags", "relation_members", "referrers"};
    }

    @Override
    public String getUsage() {
        return "downloads the specified objects from the server";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/load_object?new_layer=true&objects=w106159509", "/load_object?new_layer=true&objects=r2263653&relation_members=true", "/load_object?objects=n100000&referrers=false"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
            Main.info("RemoteControl: download forbidden by preferences");
        }
        if (!this.ps.isEmpty()) {
            boolean bl = this.isLoadInNewLayer();
            boolean bl2 = Boolean.parseBoolean((String)this.args.get("relation_members"));
            boolean bl3 = Boolean.parseBoolean((String)this.args.get("referrers"));
            final DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = new DownloadPrimitivesWithReferrersTask(bl, this.ps, bl3, bl2, (String)this.args.get("layer_name"), null);
            Main.worker.submit(downloadPrimitivesWithReferrersTask);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    final List<PrimitiveId> list = downloadPrimitivesWithReferrersTask.getDownloadedId();
                    final DataSet dataSet = Main.getLayerManager().getEditDataSet();
                    if (list != null) {
                        GuiHelper.runInEDT(new Runnable(){

                            @Override
                            public void run() {
                                dataSet.setSelected(list);
                            }
                        });
                        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
                        for (PrimitiveId primitiveId : list) {
                            hashSet.add(dataSet.getPrimitiveById(primitiveId));
                        }
                        AddTagsDialog.addTags(LoadObjectHandler.this.args, LoadObjectHandler.this.sender, hashSet);
                    }
                    LoadObjectHandler.this.ps.clear();
                }
            });
        }
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load objects (specified by their id) from the API.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.ps.clear();
        for (String string : (this.args != null ? (String)this.args.get("objects") : "").split(",\\s*")) {
            try {
                this.ps.add(SimplePrimitiveId.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.warn("RemoteControl: invalid selection '" + string + "' ignored");
            }
        }
    }
}

