/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.Execute;
import com.oracle.truffle.api.interop.ForeignObjectAccessHeadNode;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

public final class ForeignAccess {
    private final Factory factory;
    private final Thread initThread;
    private final RootNode languageCheck;

    private ForeignAccess(Factory faf) {
        this(null, faf);
    }

    private ForeignAccess(RootNode languageCheck, Factory faf) {
        this.factory = faf;
        this.initThread = Thread.currentThread();
        this.languageCheck = languageCheck;
        CompilerAsserts.neverPartOfCompilation("do not create a ForeignAccess object from compiled code");
    }

    public static ForeignAccess create(Class<? extends TruffleObject> baseClass, Factory10 factory) {
        if (baseClass == null) {
            Factory f = (Factory)((Object)factory);
            assert (f != null);
        }
        return new ForeignAccess(new DelegatingFactory(baseClass, factory));
    }

    public static ForeignAccess create(Factory10 factory, RootNode languageCheck) {
        return new ForeignAccess(languageCheck, new DelegatingFactory(null, factory));
    }

    public static ForeignAccess create(Factory factory) {
        return new ForeignAccess(factory);
    }

    @Deprecated
    public static Object execute(Node foreignNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)foreignNode;
        return fn.executeForeign(frame, receiver, arguments);
    }

    public static Object send(Node foreignNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) throws InteropException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)foreignNode;
        return fn.executeForeignImpl(frame, receiver, arguments);
    }

    public static Object sendRead(Node readNode, VirtualFrame frame, TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)readNode;
        try {
            return fn.executeForeignImpl(frame, receiver, identifier);
        }
        catch (UnsupportedMessageException e) {
            throw e;
        }
        catch (UnknownIdentifierException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendWrite(Node writeNode, VirtualFrame frame, TruffleObject receiver, Object identifier, Object value) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)writeNode;
        try {
            return fn.executeForeignImpl(frame, receiver, identifier, value);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendUnbox(Node unboxNode, VirtualFrame frame, TruffleObject receiver) throws UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)unboxNode;
        try {
            return fn.executeForeignImpl(frame, receiver, new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendExecute(Node executeNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)executeNode;
        try {
            return fn.executeForeignImpl(frame, receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw e;
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static boolean sendIsExecutable(Node isExecutableNode, VirtualFrame frame, TruffleObject receiver) {
        try {
            return (Boolean)ForeignAccess.send(isExecutableNode, frame, receiver, new Object[0]);
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendInvoke(Node invokeNode, VirtualFrame frame, TruffleObject receiver, String identifier, Object ... arguments) throws UnsupportedTypeException, ArityException, UnknownIdentifierException, UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)invokeNode;
        try {
            Object[] args = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, args, 1, arguments.length);
            args[0] = identifier;
            return fn.executeForeignImpl(frame, receiver, args);
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendNew(Node newNode, VirtualFrame frame, TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)newNode;
        try {
            return fn.executeForeignImpl(frame, receiver, arguments);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static boolean sendIsNull(Node isNullNode, VirtualFrame frame, TruffleObject receiver) {
        try {
            return (Boolean)ForeignAccess.send(isNullNode, frame, receiver, new Object[0]);
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static boolean sendHasSize(Node hasSizeNode, VirtualFrame frame, TruffleObject receiver) {
        try {
            return (Boolean)ForeignAccess.send(hasSizeNode, frame, receiver, new Object[0]);
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static Object sendGetSize(Node getSizeNode, VirtualFrame frame, TruffleObject receiver) throws UnsupportedMessageException {
        ForeignObjectAccessHeadNode fn = (ForeignObjectAccessHeadNode)getSizeNode;
        try {
            return fn.executeForeignImpl(frame, receiver, new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            throw e;
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static boolean sendIsBoxed(Node isBoxedNode, VirtualFrame frame, TruffleObject receiver) {
        try {
            return (Boolean)ForeignAccess.send(isBoxedNode, frame, receiver, new Object[0]);
        }
        catch (InteropException e) {
            throw new AssertionError("Unexpected exception catched.", e);
        }
    }

    public static List<Object> getArguments(Frame frame) {
        Object[] arr = frame.getArguments();
        return ReadOnlyArrayList.asList(arr, 1, arr.length);
    }

    public static TruffleObject getReceiver(Frame frame) {
        return (TruffleObject)frame.getArguments()[0];
    }

    public String toString() {
        Object f = this.factory instanceof DelegatingFactory ? ((DelegatingFactory)this.factory).factory : this.factory;
        return "ForeignAccess[" + f.getClass().getName() + "]";
    }

    private void checkThread() {
        assert (this.initThread == Thread.currentThread());
    }

    CallTarget access(Message message) {
        this.checkThread();
        return this.factory.accessMessage(message);
    }

    CallTarget checkLanguage() {
        if (this.languageCheck != null) {
            return Truffle.getRuntime().createCallTarget((RootNode)this.languageCheck.deepCopy());
        }
        return null;
    }

    boolean canHandle(TruffleObject receiver) {
        this.checkThread();
        return this.factory.canHandle(receiver);
    }

    private static class DelegatingFactory
    implements Factory {
        private final Class<?> baseClass;
        private final Factory10 factory;

        DelegatingFactory(Class<?> baseClass, Factory10 factory) {
            this.baseClass = baseClass;
            this.factory = factory;
        }

        @Override
        public boolean canHandle(TruffleObject obj) {
            if (this.baseClass == null) {
                return ((Factory)((Object)this.factory)).canHandle(obj);
            }
            return this.baseClass.isInstance(obj);
        }

        @Override
        public CallTarget accessMessage(Message msg) {
            return DelegatingFactory.accessMessage(this.factory, msg);
        }

        private static CallTarget accessMessage(Factory10 factory, Message msg) {
            if (msg instanceof KnownMessage) {
                switch (msg.hashCode()) {
                    case 423430: {
                        return factory.accessExecute(((Execute)msg).getArity());
                    }
                    case 423429: {
                        return factory.accessInvoke(((Execute)msg).getArity());
                    }
                    case 423428: {
                        return factory.accessNew(((Execute)msg).getArity());
                    }
                    case 423432: {
                        return factory.accessGetSize();
                    }
                    case 423433: {
                        return factory.accessHasSize();
                    }
                    case 423434: {
                        return factory.accessIsBoxed();
                    }
                    case 423435: {
                        return factory.accessIsExecutable();
                    }
                    case 423436: {
                        return factory.accessIsNull();
                    }
                    case 423438: {
                        return factory.accessRead();
                    }
                    case 423437: {
                        return factory.accessUnbox();
                    }
                    case 423431: {
                        return factory.accessWrite();
                    }
                }
            }
            return factory.accessMessage(msg);
        }
    }

    public static interface Factory10 {
        public CallTarget accessIsNull();

        public CallTarget accessIsExecutable();

        public CallTarget accessIsBoxed();

        public CallTarget accessHasSize();

        public CallTarget accessGetSize();

        public CallTarget accessUnbox();

        public CallTarget accessRead();

        public CallTarget accessWrite();

        public CallTarget accessExecute(int var1);

        public CallTarget accessInvoke(int var1);

        public CallTarget accessNew(int var1);

        public CallTarget accessMessage(Message var1);
    }

    public static interface Factory {
        public boolean canHandle(TruffleObject var1);

        public CallTarget accessMessage(Message var1);
    }
}

