/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.initializer.InitializerVisitor;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final KtClassOrObject classDeclaration;
    @NotNull
    private final List<JsStatement> initializerStatements;
    private final JsFunction initFunction;
    private final TranslationContext context;

    public ClassInitializerTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        super(context);
        this.initializerStatements = new SmartList<JsStatement>();
        this.classDeclaration = classDeclaration;
        this.initFunction = ClassInitializerTranslator.createInitFunction(classDeclaration, context);
        this.context = context.contextWithScope(this.initFunction);
    }

    @Override
    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "context"));
        }
        return translationContext;
    }

    @NotNull
    private static JsFunction createInitFunction(KtClassOrObject declaration, TranslationContext context) {
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            JsFunction jsFunction = context.getFunctionObject(primaryConstructor2);
            if (jsFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "createInitFunction"));
            }
            return jsFunction;
        }
        JsFunction jsFunction = new JsFunction(context.scope(), new JsBlock(), "fake constructor for " + classDescriptor.getName().asString());
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "createInitFunction"));
        }
        return jsFunction;
    }

    @NotNull
    public JsFunction generateInitializeMethod(DelegationTranslator delegationTranslator) {
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(this.bindingContext(), this.classDeclaration);
        this.addOuterClassReference(classDescriptor);
        ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            this.initFunction.getBody().getStatements().addAll(FunctionBodyTranslator.setDefaultValueForArguments(primaryConstructor2, this.context()));
            this.initFunction.getParameters().addAll(this.translatePrimaryConstructorParameters());
            this.mayBeAddCallToSuperMethod(this.initFunction, classDescriptor);
        }
        delegationTranslator.addInitCode(this.initializerStatements);
        new InitializerVisitor(this.initializerStatements).traverseContainer(this.classDeclaration, this.context());
        List<JsStatement> statements = this.initFunction.getBody().getStatements();
        for (JsStatement statement : this.initializerStatements) {
            if (statement instanceof JsBlock) {
                statements.addAll(((JsBlock)statement).getStatements());
                continue;
            }
            statements.add(statement);
        }
        JsFunction jsFunction = this.initFunction;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateInitializeMethod"));
        }
        return jsFunction;
    }

    private void addOuterClassReference(ClassDescriptor classDescriptor) {
        JsName outerName = this.context.getOuterClassReference(classDescriptor);
        if (outerName == null) {
            return;
        }
        this.initFunction.getParameters().add(0, new JsParameter(outerName));
        JsNameRef paramRef = JsAstUtils.pureFqn(outerName, null);
        JsBinaryOperation assignment = JsAstUtils.assignment(JsAstUtils.pureFqn(outerName, (JsExpression)JsLiteral.THIS), paramRef);
        this.initFunction.getBody().getStatements().add(new JsExpressionStatement(assignment));
    }

    @NotNull
    public JsExpression generateEnumEntryInstanceCreation(@NotNull KotlinType enumClassType) {
        if (enumClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassType", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
        if (superCall == null) {
            ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(enumClassType);
            JsNameRef reference = this.context().getQualifiedReference(classDescriptor);
            JsNew jsNew = new JsNew(reference);
            if (jsNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
            }
            return jsNew;
        }
        JsExpression jsExpression = CallTranslator.translate(this.context(), superCall);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        return jsExpression;
    }

    private void mayBeAddCallToSuperMethod(JsFunction initializer2, @NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddCallToSuperMethod"));
        }
        if (this.classDeclaration.hasModifier(KtTokens.ENUM_KEYWORD)) {
            this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer2);
        } else if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
            if (superCall == null) {
                if (DescriptorUtils.isEnumEntry(descriptor2)) {
                    this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer2);
                }
                return;
            }
            if (this.classDeclaration instanceof KtEnumEntry) {
                JsExpression expression = CallTranslator.translate(this.context(), superCall, null);
                JsExpression fixedInvocation = AstUtilsKt.toInvocationWith(expression, Collections.emptyList(), JsLiteral.THIS);
                this.initializerStatements.add(0, fixedInvocation.makeStmt());
            } else {
                ArrayList<JsExpression> arguments2 = new ArrayList<JsExpression>();
                ConstructorDescriptor superDescriptor = (ConstructorDescriptor)superCall.getResultingDescriptor();
                List<DeclarationDescriptor> superclassClosure = this.context.getClassOrConstructorClosure(superDescriptor);
                if (superclassClosure != null) {
                    UsageTracker tracker = this.context.usageTracker();
                    assert (tracker != null) : "Closure exists, therefore UsageTracker must exist too. Translating constructor of " + descriptor2;
                    for (DeclarationDescriptor capturedValue : superclassClosure) {
                        tracker.used(capturedValue);
                        arguments2.add(tracker.getCapturedDescriptorToJsName().get(capturedValue).makeRef());
                    }
                }
                if (superDescriptor.getContainingDeclaration().isInner() && descriptor2.isInner()) {
                    arguments2.add(JsAstUtils.pureFqn("$outer", (JsExpression)JsLiteral.THIS));
                }
                if (!DescriptorUtils.isAnonymousObject(descriptor2)) {
                    arguments2.addAll(CallArgumentTranslator.translate(superCall, null, this.context()).getTranslateArguments());
                } else {
                    for (ValueParameterDescriptor parameter : superDescriptor.getValueParameters()) {
                        JsName parameterName = this.context.getNameForDescriptor(parameter);
                        arguments2.add(parameterName.makeRef());
                        initializer2.getParameters().add(new JsParameter(parameterName));
                    }
                }
                this.addCallToSuperMethod(arguments2, initializer2);
            }
        }
    }

    private void addCallToSuperMethod(@NotNull List<JsExpression> arguments2, JsFunction initializer2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperMethod"));
        }
        JsName ref = this.context().scope().declareName("$fun");
        initializer2.setName(ref);
        JsInvocation call = new JsInvocation((JsExpression)Namer.getFunctionCallRef(Namer.superMethodNameRef(ref)), new JsExpression[0]);
        call.getArguments().add(JsLiteral.THIS);
        call.getArguments().addAll(arguments2);
        this.initializerStatements.add(0, call.makeStmt());
    }

    @NotNull
    private List<JsParameter> translatePrimaryConstructorParameters() {
        List<KtParameter> parameterList = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result2 = new ArrayList<JsParameter>();
        for (KtParameter jetParameter : parameterList) {
            result2.add(this.translateParameter(jetParameter));
        }
        ArrayList<JsParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translatePrimaryConstructorParameters"));
        }
        return arrayList;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull KtParameter jetParameter) {
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), jetParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, jetParameter);
        JsParameter jsParameter2 = jsParameter;
        if (jsParameter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        return jsParameter2;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull KtParameter jetParameter) {
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter);
        if (propertyDescriptor == null) {
            return;
        }
        JsNameRef initialValueForProperty = jsParameter.getName().makeRef();
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsNameRef initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }
}

