/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class InstructionAdder
extends SimplifiedVisitor
implements InstructionVisitor {
    private final ConstantAdder constantAdder;
    private final CodeAttributeComposer codeAttributeComposer;

    public InstructionAdder(ProgramClass programClass, CodeAttributeComposer codeAttributeComposer) {
        this.constantAdder = new ConstantAdder(programClass);
        this.codeAttributeComposer = codeAttributeComposer;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(n, instruction);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        ConstantInstruction constantInstruction2 = new ConstantInstruction(constantInstruction.opcode, this.constantAdder.addConstant(clazz, constantInstruction.constantIndex), constantInstruction.constant);
        this.codeAttributeComposer.appendInstruction(n, constantInstruction2);
    }
}

