/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase.types;

import java.util.StringTokenizer;

public class DoubleRange {
    private double minimum;
    private double maximum;

    public DoubleRange(double minimum, double maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public DoubleRange(String range) {
        StringTokenizer st = new StringTokenizer(range.trim(), ",");
        if (st.countTokens() != 2) {
            throw new RangeFormatException();
        }
        String firstHalf = st.nextToken();
        String lastHalf = st.nextToken();
        String minString = firstHalf.substring(1).trim();
        String maxString = lastHalf.substring(0, lastHalf.length() - 1).trim();
        this.minimum = !minString.equals("") ? Double.parseDouble(minString) : -1.7976931348623157E308;
        this.maximum = !maxString.equals("") ? Double.parseDouble(maxString) : Double.MAX_VALUE;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.minimum != -1.7976931348623157E308) {
            buffer.append(Double.toString(this.minimum));
        }
        buffer.append(",");
        if (this.maximum != Double.MAX_VALUE) {
            buffer.append(Double.toString(this.maximum));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public boolean inRange(double d) {
        return d >= this.minimum && d <= this.maximum;
    }

    public double forceInRange(double d) {
        return Math.max(this.minimum, Math.min(this.maximum, d));
    }

    protected class RangeFormatException
    extends RuntimeException {
        public RangeFormatException() {
        }

        public RangeFormatException(String s) {
            super(s);
        }
    }
}

