/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import java.io.File;
import java.io.IOException;

public class UserSettings
extends Settings {
    public static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ili2c";
    public static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    public static final String ILIDIRS = "ch.interlis.ili2c.ilidirs";
    public static final String HTTP_PROXY_HOST = "ch.interlis.ili2c.http_proxy_host";
    public static final String HTTP_PROXY_PORT = "ch.interlis.ili2c.http_proxy_port";
    public static final String TEMP_REPOS_URI = "ch.interlis.ili2c.tempReposUri";
    public static final String TEMP_REPOS_ILIFILES = "ch.interlis.ili2c.tempReposIliFiles";
    public static final String CUSTOM_ILI_RESOLVER = "ch.interlis.ili2c.customIliResolver";
    public static final String ILIDIRS_PATHMAP = "ch.interlis.ili2c.pathMap";

    public static UserSettings load() {
        UserSettings userSettings = new UserSettings();
        try {
            String wd;
            String ilidirs;
            File f = new File(SETTINGS_FILE);
            if (f.exists()) {
                userSettings.load(f);
            }
            if ((ilidirs = userSettings.getIlidirs()) == null) {
                userSettings.setIlidirs("%ILI_DIR;http://models.interlis.ch/;%JAR_DIR");
            }
            if ((wd = userSettings.getWorkingDirectory()) == null) {
                userSettings.setWorkingDirectory(System.getProperty("user.home"));
            }
        }
        catch (IOException e) {
            EhiLogger.logError("failed to load settings", e);
        }
        return userSettings;
    }

    public void save() {
        try {
            this.store(new File(SETTINGS_FILE), "ili2c");
        }
        catch (IOException e) {
            EhiLogger.logError("failed to save settings", e);
        }
    }

    public String getWorkingDirectory() {
        return this.getValue(WORKING_DIRECTORY);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.setValue(WORKING_DIRECTORY, workingDirectory);
    }

    public String getIlidirs() {
        return this.getValue(ILIDIRS);
    }

    public void setIlidirs(String workingDirectory) {
        this.setValue(ILIDIRS, workingDirectory);
    }

    public String getHttpProxyHost() {
        return this.getValue(HTTP_PROXY_HOST);
    }

    public void setHttpProxyHost(String workingDirectory) {
        this.setValue(HTTP_PROXY_HOST, workingDirectory);
    }

    public String getHttpProxyPort() {
        return this.getValue(HTTP_PROXY_PORT);
    }

    public void setHttpProxyPort(String workingDirectory) {
        this.setValue(HTTP_PROXY_PORT, workingDirectory);
    }
}

