/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.draw;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.diagram.draw.DrawHandler;
import java.util.Arrays;
import java.util.List;

public class DrawHelper {
    public static List<PointDouble> drawPackage(DrawHandler drawer, double upperLeftX, double upperLeftY, double titleHeight, double titleWidth, double fullHeight, double fullWidth) {
        PointDouble start = new PointDouble(upperLeftX, upperLeftY);
        List<PointDouble> points = Arrays.asList(start, new PointDouble(upperLeftX + titleWidth, upperLeftY), new PointDouble(upperLeftX + titleWidth, upperLeftY + titleHeight), new PointDouble(upperLeftX + fullWidth, upperLeftY + titleHeight), new PointDouble(upperLeftX + fullWidth, upperLeftY + fullHeight), new PointDouble(upperLeftX, upperLeftY + fullHeight), start);
        drawer.drawLines(points);
        drawer.drawLines(new PointDouble(upperLeftX, upperLeftY + titleHeight), new PointDouble(upperLeftX + titleWidth, upperLeftY + titleHeight));
        return points;
    }

    public static void drawActor(DrawHandler drawer, int hCenter, int yTop, double dimension) {
        drawer.drawCircle(hCenter, (double)yTop + DrawHelper.headRadius(dimension), DrawHelper.headRadius(dimension));
        drawer.drawLine((double)hCenter - DrawHelper.armLength(dimension), (double)yTop + DrawHelper.armHeight(dimension), (double)hCenter + DrawHelper.armLength(dimension), (double)yTop + DrawHelper.armHeight(dimension));
        drawer.drawLine(hCenter, (double)yTop + DrawHelper.headRadius(dimension) * 2.0, hCenter, (double)yTop + DrawHelper.headToBodyLength(dimension));
        drawer.drawLine(hCenter, (double)yTop + DrawHelper.headToBodyLength(dimension), (double)hCenter - DrawHelper.legSpan(dimension), (double)yTop + DrawHelper.headToLegLength(dimension));
        drawer.drawLine(hCenter, (double)yTop + DrawHelper.headToBodyLength(dimension), (double)hCenter + DrawHelper.legSpan(dimension), (double)yTop + DrawHelper.headToLegLength(dimension));
    }

    public static double headToLegLength(double dimension) {
        return DrawHelper.legSpan(dimension) * 2.0 + DrawHelper.headToBodyLength(dimension);
    }

    private static double legSpan(double dimension) {
        return dimension;
    }

    private static double headToBodyLength(double dimension) {
        return dimension * 2.0 + DrawHelper.headRadius(dimension) * 2.0;
    }

    private static double armHeight(double dimension) {
        return DrawHelper.armLength(dimension);
    }

    public static double armLength(double dimension) {
        return dimension * 1.5;
    }

    private static double headRadius(double dimension) {
        return dimension / 2.0;
    }
}

