/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class AntiCsrfDetectScanner
implements PassiveScanner {
    public static final String ACSRF_STATS_PREFIX = "stats.acsrf.";
    private PassiveScanThread parent = null;
    private final ExtensionAntiCSRF extAntiCSRF;

    public AntiCsrfDetectScanner(ExtensionAntiCSRF extensionAntiCSRF) {
        this.extAntiCSRF = extensionAntiCSRF;
    }

    @Override
    public void setParent(PassiveScanThread passiveScanThread) {
        this.parent = passiveScanThread;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        List<AntiCsrfToken> list = this.extAntiCSRF.getTokensFromResponse(httpMessage, source);
        for (AntiCsrfToken antiCsrfToken : list) {
            if (this.registerToken(httpMessage.getHistoryRef().getHistoryType())) {
                if (this.parent != null) {
                    this.parent.addTag(n, "AntiCSRF");
                }
                this.extAntiCSRF.registerAntiCsrfToken(antiCsrfToken);
            }
            try {
                Stats.incCounter(SessionStructure.getHostName(httpMessage), ACSRF_STATS_PREFIX + antiCsrfToken.getName());
            }
            catch (URIException uRIException) {}
        }
    }

    @Override
    public String getName() {
        return "Anti CSRF Token Detection";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        return Plugin.AlertThreshold.MEDIUM;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold alertThreshold) {
    }

    private boolean registerToken(int n) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(n);
    }

    @Override
    public boolean appliesToHistoryType(int n) {
        return true;
    }
}

