/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.forceduser;

import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authentication.AuthenticationAPI;
import org.zaproxy.zap.extension.forceduser.ExtensionForcedUser;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class ForcedUserAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(AuthenticationAPI.class);
    private static final String PREFIX = "forcedUser";
    private static final String VIEW_GET_FORCED_USER = "getForcedUser";
    private static final String VIEW_IS_FORCED_USER_MODE_ENABLED = "isForcedUserModeEnabled";
    private static final String ACTION_SET_FORCED_USER = "setForcedUser";
    private static final String ACTION_SET_FORCED_USER_MODE_ENABLED = "setForcedUserModeEnabled";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_MODE_ENABLED = "boolean";
    private ExtensionForcedUser extension;

    public ForcedUserAPI(ExtensionForcedUser extensionForcedUser) {
        this.extension = extensionForcedUser;
        this.addApiView(new ApiView(VIEW_IS_FORCED_USER_MODE_ENABLED));
        this.addApiView(new ApiView(VIEW_GET_FORCED_USER, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_FORCED_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_FORCED_USER_MODE_ENABLED, new String[]{PARAM_MODE_ENABLED}));
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "getForcedUser": {
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                User user = this.extension.getForcedUser(context.getIndex());
                if (user != null) {
                    return new ApiResponseElement("forcedUserId", Integer.toString(user.getId()));
                }
                return new ApiResponseElement("forcedUserId", "");
            }
            case "isForcedUserModeEnabled": {
                return new ApiResponseElement("forcedModeEnabled", Boolean.toString(this.extension.isForcedUserModeEnabled()));
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "setForcedUser": {
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                int n = ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
                try {
                    this.extension.setForcedUser(context.getIndex(), n);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND);
                }
                context.save();
                return ApiResponseElement.OK;
            }
            case "setForcedUserModeEnabled": {
                boolean bl;
                if (!jSONObject.containsKey((Object)PARAM_MODE_ENABLED)) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_MODE_ENABLED);
                }
                try {
                    bl = jSONObject.getBoolean(PARAM_MODE_ENABLED);
                }
                catch (JSONException jSONException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MODE_ENABLED);
                }
                this.extension.setForcedUserModeEnabled(bl);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

