/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDummyUpstreamSurfaceHook;
import jogamp.opengl.egl.EGLES1DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLES2DynamicLibraryBundleInfo;
import jogamp.opengl.egl.EGLExternalContext;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLOnscreenDrawable;
import jogamp.opengl.egl.EGLPbufferDrawable;
import jogamp.opengl.egl.EGLWrappedSurface;

public class EGLDrawableFactory
extends GLDrawableFactoryImpl {
    protected static final boolean DEBUG = GLDrawableFactoryImpl.DEBUG;
    static final boolean QUERY_EGL_ES_NATIVE_TK;
    private static GLDynamicLookupHelper eglES1DynamicLookupHelper;
    private static GLDynamicLookupHelper eglES2DynamicLookupHelper;
    private HashMap<String, SharedResource> sharedMap = null;
    private HashSet<String> sharedMapCreateAttempt = null;
    private EGLGraphicsDevice defaultDevice = null;
    private SharedResource defaultSharedResource = null;
    private boolean isANGLE = false;
    private boolean hasX11 = false;

    private static final boolean isANGLE(GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (Platform.OSType.WINDOWS == Platform.OS_TYPE) {
            return gLDynamicLookupHelper.isFunctionAvailable("eglQuerySurfacePointerANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glBlitFramebufferANGLE") || gLDynamicLookupHelper.isFunctionAvailable("glRenderbufferStorageMultisampleANGLE");
        }
        return false;
    }

    private static final boolean includesES1(GLDynamicLookupHelper gLDynamicLookupHelper) {
        return gLDynamicLookupHelper.isFunctionAvailable("glLoadIdentity") && gLDynamicLookupHelper.isFunctionAvailable("glEnableClientState") && gLDynamicLookupHelper.isFunctionAvailable("glColorPointer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EGLDrawableFactory() {
        EGLGraphicsConfigurationFactory.registerFactory();
        if (NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType(true)) {
            this.hasX11 = true;
            try {
                ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory", (ClassLoader)EGLDrawableFactory.class.getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<EGLDrawableFactory> clazz = EGLDrawableFactory.class;
        synchronized (EGLDrawableFactory.class) {
            GLDynamicLookupHelper gLDynamicLookupHelper;
            boolean bl;
            boolean bl2 = bl = null != eglES2DynamicLookupHelper;
            if (!bl && null == eglES1DynamicLookupHelper) {
                block27: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES1DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block27;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES1DynamicLookupHelper);
                    boolean bl3 = EGLDrawableFactory.isANGLE(eglES1DynamicLookupHelper);
                    this.isANGLE |= bl3;
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK, isANGLE: " + bl3);
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES1 - NOPE (ES1 lib)");
                }
            }
            if (!bl && null == eglES2DynamicLookupHelper) {
                block28: {
                    gLDynamicLookupHelper = null;
                    try {
                        gLDynamicLookupHelper = new GLDynamicLookupHelper(new EGLES2DynamicLibraryBundleInfo());
                    }
                    catch (GLException gLException) {
                        if (!DEBUG) break block28;
                        gLException.printStackTrace();
                    }
                }
                if (null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete()) {
                    boolean bl4;
                    eglES2DynamicLookupHelper = gLDynamicLookupHelper;
                    EGL.resetProcAddressTable((DynamicLookupHelper)eglES2DynamicLookupHelper);
                    boolean bl5 = bl4 = null == eglES1DynamicLookupHelper && EGLDrawableFactory.includesES1(eglES2DynamicLookupHelper);
                    if (bl4) {
                        eglES1DynamicLookupHelper = gLDynamicLookupHelper;
                    }
                    boolean bl6 = EGLDrawableFactory.isANGLE(eglES2DynamicLookupHelper);
                    this.isANGLE |= bl6;
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory: EGL ES2 - OK (includesES1 " + bl4 + ", isANGLE: " + bl6 + ")");
                        if (bl4) {
                            System.err.println("Info: EGLDrawableFactory: EGL ES1 - OK (ES2 lib)");
                        }
                    }
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("Info: EGLDrawableFactory: EGL ES2 - NOPE");
                }
            }
            if (null != eglES2DynamicLookupHelper || null != eglES1DynamicLookupHelper) {
                if (this.isANGLE && !enableANGLE) {
                    if (DEBUG || GLProfile.DEBUG) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE disabled");
                    }
                } else {
                    if (this.isANGLE && (DEBUG || GLProfile.DEBUG)) {
                        System.err.println("Info: EGLDrawableFactory.init - EGL/ES2 ANGLE enabled");
                    }
                    this.sharedMap = new HashMap();
                    this.sharedMapCreateAttempt = new HashSet();
                    this.defaultDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, "decon", 0);
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != this.sharedMap;
    }

    @Override
    protected final void shutdownImpl() {
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.shutdown");
        }
        if (null != this.sharedMap) {
            if (DEBUG) {
                this.dumpMap();
            }
            Collection<SharedResource> collection = this.sharedMap.values();
            for (SharedResource sharedResource : collection) {
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.shutdown: " + sharedResource.device.toString());
                }
                sharedResource.device.close();
            }
            this.sharedMap.clear();
            this.sharedMapCreateAttempt.clear();
            this.sharedMap = null;
            this.sharedMapCreateAttempt = null;
        }
        if (null != this.defaultSharedResource) {
            this.defaultSharedResource = null;
        }
        if (null != this.defaultDevice) {
            this.defaultDevice.close();
            this.defaultDevice = null;
        }
        if (null != eglES1DynamicLookupHelper) {
            eglES1DynamicLookupHelper = null;
        }
        if (null != eglES2DynamicLookupHelper) {
            eglES2DynamicLookupHelper = null;
        }
        EGLGraphicsConfigurationFactory.unregisterFactory();
        EGLDisplayUtil.shutdown(DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMap() {
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            System.err.println("EGLDrawableFactory.map " + this.sharedMap.size());
            int n = 0;
            Set<String> set = this.sharedMap.keySet();
            for (String string : set) {
                SharedResource sharedResource = this.sharedMap.get(string);
                System.err.println("EGLDrawableFactory.map[" + n + "] " + string + " -> " + sharedResource.getDevice() + ", " + "es1   [avail " + sharedResource.wasES1ContextCreated + ", pbuffer " + sharedResource.hasPBufferES1 + ", quirks " + sharedResource.rendererQuirksES1 + ", ctp " + EGLContext.getGLVersion(1, 0, sharedResource.ctpES1, null) + "], " + "es2/3 [es2 " + sharedResource.wasES2ContextCreated + ", es3 " + sharedResource.wasES3ContextCreated + ", [pbuffer " + sharedResource.hasPBufferES3ES2 + ", quirks " + sharedResource.rendererQuirksES3ES2 + ", ctp " + EGLContext.getGLVersion(2, 0, sharedResource.ctpES3ES2, null) + "]]");
                ++n;
            }
        }
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != this.sharedMap;
    }

    private static List<GLCapabilitiesImmutable> getAvailableEGLConfigs(EGLGraphicsDevice eGLGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigs(eGLGraphicsDevice.getHandle(), null, 0, intBuffer)) {
            throw new GLException("EGLDrawableFactory.getAvailableEGLConfigs: Get maxConfigs (eglGetConfigs) call failed, error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (0 < intBuffer.get(0)) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)intBuffer.get(0));
            IntBuffer intBuffer2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
            int n = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            if (EGL.eglChooseConfig(eGLGraphicsDevice.getHandle(), intBuffer2, pointerBuffer, pointerBuffer.capacity(), intBuffer) && intBuffer.get(0) > 0) {
                return EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(eGLGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), pointerBuffer, intBuffer.get(0), n, false, false);
            }
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    private static void dumpEGLInfo(String string, long l) {
        String string2 = EGL.eglQueryString(l, 12371);
        String string3 = EGL.eglQueryString(l, 12429);
        String string4 = EGL.eglQueryString(l, 12372);
        System.err.println(string + "EGL vendor " + string2 + ", version " + string4 + ", clientAPIs " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapAvailableEGLESConfig(AbstractGraphicsDevice abstractGraphicsDevice, int[] nArray, boolean[] blArray, GLRendererQuirks[] gLRendererQuirksArray, int[] nArray2) {
        boolean bl;
        block59: {
            boolean bl2;
            String string;
            switch (nArray[0]) {
                case 3: {
                    string = "GLES3";
                    break;
                }
                case 2: {
                    string = "GLES2";
                    break;
                }
                case 1: {
                    string = "GLES1";
                    break;
                }
                default: {
                    throw new GLException("Invalid ES profile number " + nArray);
                }
            }
            if (!GLProfile.isAvailable(abstractGraphicsDevice, string)) {
                if (DEBUG) {
                    System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + string + " n/a on " + abstractGraphicsDevice);
                }
                return false;
            }
            GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
            GLDrawableFactoryImpl gLDrawableFactoryImpl = (GLDrawableFactoryImpl)GLDrawableFactory.getDesktopFactory();
            boolean bl3 = 0L == this.defaultDevice.getHandle();
            boolean bl4 = bl2 = !QUERY_EGL_ES_NATIVE_TK || bl3 || null == gLDrawableFactoryImpl || abstractGraphicsDevice instanceof EGLGraphicsDevice;
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + string + " ( " + nArray + " ), " + "defaultSharedResourceSet " + (null != this.defaultSharedResource) + ", mapsADeviceToDefaultDevice " + bl2 + " (QUERY_EGL_ES_NATIVE_TK " + QUERY_EGL_ES_NATIVE_TK + ", hasDesktopFactory " + (null != gLDrawableFactoryImpl) + ", isEGLGraphicsDevice " + (abstractGraphicsDevice instanceof EGLGraphicsDevice) + ")");
            }
            EGLGraphicsDevice eGLGraphicsDevice = null;
            ProxySurface proxySurface = null;
            ProxySurface proxySurface2 = null;
            ProxySurface proxySurface3 = null;
            bl = false;
            try {
                Object object;
                Object object2;
                Object object3;
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                gLCapabilities.setRedBits(5);
                gLCapabilities.setGreenBits(5);
                gLCapabilities.setBlueBits(5);
                gLCapabilities.setAlphaBits(0);
                gLCapabilities.setDoubleBuffered(false);
                if (bl2) {
                    if (bl3) {
                        this.defaultDevice.open();
                        long l = EGL.eglGetDisplay(0L);
                        if (0L == l) {
                            object3 = new int[]{16};
                            GLRendererQuirks.addStickyDeviceQuirks(abstractGraphicsDevice, (int[])object3, 0, 1);
                            EGLDisplayUtil.setSingletonEGLDisplayOnly(true);
                            if (DEBUG) {
                                System.err.println("Quirk: " + GLRendererQuirks.toString((int)object3[0]) + ": cause: Second eglGetDisplay(EGL_DEFAULT_DISPLAY) failed");
                            }
                        }
                    }
                    if (DEBUG) {
                        EGLDrawableFactory.dumpEGLInfo("EGLDrawableFactory.mapAvailableEGLESConfig: ", this.defaultDevice.getHandle());
                    }
                    boolean bl5 = blArray[0] = (object2 = EGLDrawableFactory.getAvailableEGLConfigs(this.defaultDevice, (GLCapabilitiesImmutable)(object = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilities)))).size() > 0;
                    if (abstractGraphicsDevice != this.defaultDevice) {
                        if (null == this.defaultSharedResource) {
                            boolean bl6 = false;
                            return bl6;
                        }
                        switch (nArray[0]) {
                            case 3: {
                                if (!this.defaultSharedResource.wasES3ContextCreated) {
                                    boolean bl7 = false;
                                    return bl7;
                                }
                                gLRendererQuirksArray[0] = this.defaultSharedResource.rendererQuirksES3ES2;
                                nArray2[0] = this.defaultSharedResource.ctpES3ES2;
                                break;
                            }
                            case 2: {
                                if (!this.defaultSharedResource.wasES2ContextCreated) {
                                    boolean bl8 = false;
                                    return bl8;
                                }
                                gLRendererQuirksArray[0] = this.defaultSharedResource.rendererQuirksES3ES2;
                                nArray2[0] = this.defaultSharedResource.ctpES3ES2;
                                break;
                            }
                            case 1: {
                                if (!this.defaultSharedResource.wasES1ContextCreated) {
                                    boolean bl9 = false;
                                    return bl9;
                                }
                                gLRendererQuirksArray[0] = this.defaultSharedResource.rendererQuirksES1;
                                nArray2[0] = this.defaultSharedResource.ctpES1;
                            }
                        }
                        if (null != gLRendererQuirksArray[0]) {
                            GLRendererQuirks.addStickyDeviceQuirks(abstractGraphicsDevice, gLRendererQuirksArray[0]);
                        }
                        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, nArray[0], 0, nArray2[0]);
                        boolean bl10 = true;
                        return bl10;
                    }
                    if (blArray[0]) {
                        proxySurface3 = this.createDummySurfaceImpl(this.defaultDevice, false, (GLCapabilitiesImmutable)object, (GLCapabilitiesImmutable)object, null, 64, 64);
                        if (null != proxySurface3) {
                            proxySurface3.createNotify();
                        }
                        proxySurface = proxySurface3;
                    } else {
                        object3 = EGLDrawableFactory.getAvailableEGLConfigs(this.defaultDevice, gLCapabilities);
                        if (object3.size() > 0) {
                            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)object3.get(0);
                            EGLContext.mapStaticGLESVersion(this.defaultDevice, gLCapabilitiesImmutable);
                            bl = true;
                        }
                        if (DEBUG) {
                            System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig() no pbuffer config available, detected !pbuffer config: " + bl);
                            EGLGraphicsConfigurationFactory.printCaps("!PBufferCaps", (List<GLCapabilitiesImmutable>)object3, System.err);
                        }
                    }
                    eGLGraphicsDevice = this.defaultDevice;
                } else {
                    proxySurface2 = gLDrawableFactoryImpl.createDummySurface(abstractGraphicsDevice, gLCapabilities, null, 64, 64);
                    if (null != proxySurface2) {
                        proxySurface2.createNotify();
                    }
                    proxySurface = proxySurface2;
                    eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(proxySurface);
                    eGLGraphicsDevice.open();
                    if (DEBUG) {
                        EGLDrawableFactory.dumpEGLInfo("EGLDrawableFactory.mapAvailableEGLESConfig: ", eGLGraphicsDevice.getHandle());
                    }
                    blArray[0] = true;
                }
                if (null == proxySurface) break block59;
                object = (EGLDrawable)this.createOnscreenDrawableImpl(proxySurface);
                ((GLDrawableImpl)object).setRealized(true);
                object2 = (EGLContext)((EGLDrawable)object).createContext(null);
                if (null != object2) {
                    try {
                        ((GLContextImpl)object2).makeCurrent();
                        if (((GLContext)object2).isCurrent()) {
                            object3 = ((GLContextImpl)object2).getGL().glGetString(7938);
                            if (null != object3) {
                                ((EGLContext)object2).mapCurrentAvailableGLVersion(eGLGraphicsDevice);
                                if (eGLGraphicsDevice != abstractGraphicsDevice) {
                                    ((EGLContext)object2).mapCurrentAvailableGLVersion(abstractGraphicsDevice);
                                }
                                gLRendererQuirksArray[0] = ((GLContext)object2).getRendererQuirks();
                                nArray2[0] = ((EGLContext)object2).getContextOptions();
                                nArray[0] = ((GLContext)object2).getGLVersionNumber().getMajor();
                                bl = true;
                            } else if (DEBUG) {
                                System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: " + eGLGraphicsDevice + ", " + ((GLContext)object2).getGLVersion() + " - VERSION is null, dropping availability!");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            System.err.println("EGLDrawableFactory.mapAvailableEGLESConfig: INFO: context create/makeCurrent failed");
                            throwable.printStackTrace();
                        }
                    }
                    finally {
                        ((GLContextImpl)object2).destroy();
                    }
                }
                ((GLDrawableImpl)object).setRealized(false);
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    System.err.println("Catched Exception on thread " + EGLDrawableFactory.getThreadName());
                    throwable.printStackTrace();
                }
                bl = false;
            }
            finally {
                if (null != proxySurface3) {
                    proxySurface3.destroyNotify();
                }
                if (this.defaultDevice != eGLGraphicsDevice) {
                    if (null != eGLGraphicsDevice) {
                        eGLGraphicsDevice.close();
                    }
                    if (null != proxySurface2) {
                        proxySurface2.destroyNotify();
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean needsToCreateSharedResource(String string, SharedResource[] sharedResourceArray) {
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            SharedResource sharedResource = this.sharedMap.get(string);
            if (null == sharedResource) {
                boolean bl = this.sharedMapCreateAttempt.contains(string);
                if (!bl) {
                    this.sharedMapCreateAttempt.add(string);
                }
                return !bl;
            }
            if (null != sharedResourceArray) {
                sharedResourceArray[0] = sharedResource;
            }
            return false;
        }
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedMap) {
            return null;
        }
        if (this.needsToCreateSharedResource(this.defaultDevice.getUniqueID(), null)) {
            if (DEBUG) {
                System.err.println("EGLDrawableFactory.createShared: (defaultDevice): req. device: " + abstractGraphicsDevice + ", defaultDevice " + this.defaultDevice);
                Thread.dumpStack();
            }
            if (null != this.defaultSharedResource) {
                this.dumpMap();
                throw new InternalError("defaultSharedResource already exist: " + this.defaultSharedResource);
            }
            this.defaultSharedResource = this.createEGLSharedResourceImpl(this.defaultDevice);
        }
        String string = abstractGraphicsDevice.getUniqueID();
        if (this.defaultDevice.getUniqueID().equals(string)) {
            return this.defaultSharedResource;
        }
        if (null == this.defaultSharedResource) {
            this.dumpMap();
            throw new InternalError("defaultSharedResource does not exist");
        }
        SharedResource[] sharedResourceArray = new SharedResource[]{null};
        if (!this.needsToCreateSharedResource(string, sharedResourceArray)) {
            return sharedResourceArray[0];
        }
        return this.createEGLSharedResourceImpl(abstractGraphicsDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedResource createEGLSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        Object object;
        int[] nArray;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        GLRendererQuirks[] gLRendererQuirksArray = new GLRendererQuirks[]{null};
        GLRendererQuirks[] gLRendererQuirksArray2 = new GLRendererQuirks[]{null};
        int[] nArray2 = new int[]{-1};
        int[] nArray3 = new int[]{-1};
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.createShared(): device " + abstractGraphicsDevice);
        }
        boolean bl = null != eglES1DynamicLookupHelper ? this.mapAvailableEGLESConfig(abstractGraphicsDevice, nArray = new int[]{1}, blArray, gLRendererQuirksArray, nArray2) && 1 == nArray[0] : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (null != eglES2DynamicLookupHelper) {
            object = new int[]{3};
            boolean bl4 = bl3 = this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, blArray2, gLRendererQuirksArray2, nArray3) && 3 == object[0];
            if (!bl3) {
                object[0] = 2;
                if (this.mapAvailableEGLESConfig(abstractGraphicsDevice, (int[])object, blArray2, gLRendererQuirksArray2, nArray3)) {
                    switch (object[0]) {
                        case 2: {
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            bl3 = true;
                            break;
                        }
                        default: {
                            throw new InternalError("XXXX Got " + object[0]);
                        }
                    }
                }
            }
        }
        if (!EGLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
            EGLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
        }
        if (this.hasX11) {
            this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray[0]);
            this.handleDontCloseX11DisplayQuirk(gLRendererQuirksArray2[0]);
        }
        object = new SharedResource(this.defaultDevice, bl, blArray[0], gLRendererQuirksArray[0], nArray2[0], bl2, bl3, blArray2[0], gLRendererQuirksArray2[0], nArray3[0]);
        HashMap<String, SharedResource> hashMap = this.sharedMap;
        synchronized (hashMap) {
            this.sharedMap.put(abstractGraphicsDevice.getUniqueID(), (SharedResource)object);
        }
        if (DEBUG) {
            System.err.println("EGLDrawableFactory.createShared: devices: queried nativeTK " + QUERY_EGL_ES_NATIVE_TK + ", adevice " + abstractGraphicsDevice + ", defaultDevice " + this.defaultDevice);
            System.err.println("EGLDrawableFactory.createShared: context ES1: " + bl + ", hasPBuffer " + blArray[0] + ", quirks " + gLRendererQuirksArray[0]);
            System.err.println("EGLDrawableFactory.createShared: context ES2: " + bl2 + ", hasPBuffer " + blArray2[0] + ", quirks " + gLRendererQuirksArray2[0]);
            System.err.println("EGLDrawableFactory.createShared: context ES3: " + bl3 + ", hasPBuffer " + blArray2[0] + ", quirks " + gLRendererQuirksArray2[0]);
            this.dumpMap();
        }
        return object;
    }

    private void handleDontCloseX11DisplayQuirk(GLRendererQuirks gLRendererQuirks) {
        if (null != gLRendererQuirks && gLRendererQuirks.exist(8)) {
            X11Util.markAllDisplaysUnclosable();
        }
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return null;
    }

    public final boolean isANGLE() {
        return this.isANGLE;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        if (2 == n || 3 == n) {
            return eglES2DynamicLookupHelper;
        }
        if (1 == n) {
            return eglES1DynamicLookupHelper;
        }
        throw new GLException("Unsupported: ES" + n);
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == this.sharedMap) {
            return new ArrayList<GLCapabilitiesImmutable>();
        }
        return EGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new EGLOnscreenDrawable(this, EGLWrappedSurface.get(nativeSurface));
    }

    @Override
    protected GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new GLException("Non pbuffer not yet implemented");
        }
        return new EGLPbufferDrawable(this, EGLWrappedSurface.get(nativeSurface));
    }

    @Override
    public boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        return true;
    }

    @Override
    protected ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        boolean bl2;
        EGLGraphicsDevice eGLGraphicsDevice;
        if (bl || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            long l = abstractGraphicsDevice instanceof EGLGraphicsDevice ? ((EGLGraphicsDevice)abstractGraphicsDevice).getNativeDisplayID() : abstractGraphicsDevice.getHandle();
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(l, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
            eGLGraphicsDevice.open();
            bl2 = true;
        } else {
            eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
            bl2 = false;
        }
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        if (null == eGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new WrappedSurface(eGLGraphicsConfiguration, 0L, upstreamSurfaceHook, bl2);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLPBufferGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new EGLDummyUpstreamSurfaceHook(n, n2));
    }

    protected static MutableSurface createPBufferSurfaceImpl(MutableSurface mutableSurface, boolean bl) {
        return null;
    }

    protected static long createPBufferSurfaceImpl(EGLGraphicsConfiguration eGLGraphicsConfiguration, int n, int n2, boolean bl) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities();
        int n3 = bl ? (gLCapabilitiesImmutable.getAlphaBits() > 0 ? 12382 : 12381) : 12380;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + eGLGraphicsConfiguration);
        }
        IntBuffer intBuffer = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(n, n2, n3);
        long l = EGL.eglCreatePbufferSurface(eGLGraphicsDevice.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), intBuffer);
        if (0L == l) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + n + "x" + n2 + ", " + eGLGraphicsDevice + ", " + eGLGraphicsConfiguration + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("PBuffer setSurface result: eglSurface 0x" + Long.toHexString(l));
        }
        return l;
    }

    @Override
    protected ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsDevice;
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        eGLGraphicsDevice2.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, n);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen, 0, false);
        return new WrappedSurface(eGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected GLContext createExternalGLContextImpl() {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_EGL);
        return new EGLExternalContext(abstractGraphicsScreen);
    }

    @Override
    public boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    protected GLDrawable createExternalGLDrawableImpl() {
        throw new GLException("Not yet implemented");
    }

    static {
        Debug.initSingleton();
        QUERY_EGL_ES_NATIVE_TK = Debug.isPropertyDefined((String)"jogl.debug.EGLDrawableFactory.QueryNativeTK", (boolean)true);
        eglES1DynamicLookupHelper = null;
        eglES2DynamicLookupHelper = null;
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private final EGLGraphicsDevice device;
        private final boolean wasES1ContextCreated;
        private final boolean wasES2ContextCreated;
        private final boolean wasES3ContextCreated;
        private final GLRendererQuirks rendererQuirksES1;
        private final GLRendererQuirks rendererQuirksES3ES2;
        private final int ctpES1;
        private final int ctpES3ES2;
        private final boolean hasPBufferES1;
        private final boolean hasPBufferES3ES2;

        SharedResource(EGLGraphicsDevice eGLGraphicsDevice, boolean bl, boolean bl2, GLRendererQuirks gLRendererQuirks, int n, boolean bl3, boolean bl4, boolean bl5, GLRendererQuirks gLRendererQuirks2, int n2) {
            this.device = eGLGraphicsDevice;
            this.wasES1ContextCreated = bl;
            this.hasPBufferES1 = bl2;
            this.rendererQuirksES1 = gLRendererQuirks;
            this.ctpES1 = n;
            this.wasES2ContextCreated = bl3;
            this.wasES3ContextCreated = bl4;
            this.hasPBufferES3ES2 = bl5;
            this.rendererQuirksES3ES2 = gLRendererQuirks2;
            this.ctpES3ES2 = n2;
        }

        @Override
        public final boolean isValid() {
            return this.wasES1ContextCreated || this.wasES2ContextCreated || this.wasES3ContextCreated;
        }

        @Override
        public final EGLGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public AbstractGraphicsScreen getScreen() {
            return null;
        }

        @Override
        public GLDrawableImpl getDrawable() {
            return null;
        }

        @Override
        public GLContextImpl getContext() {
            return null;
        }

        @Override
        public GLRendererQuirks getRendererQuirks() {
            return null != this.rendererQuirksES3ES2 ? this.rendererQuirksES3ES2 : this.rendererQuirksES1;
        }
    }
}

