/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class DownloadTaskList {
    private final List<DownloadTask> tasks = new LinkedList<DownloadTask>();
    private final List<Future<?>> taskFutures = new LinkedList();
    private ProgressMonitor progressMonitor;

    private void addDownloadTask(ProgressMonitor progressMonitor, DownloadTask downloadTask, Rectangle2D rectangle2D, int n, int n2) {
        ProgressMonitor progressMonitor2 = progressMonitor.createSubTaskMonitor(1, false);
        progressMonitor2.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", n, n2, n2 - n));
        Future<?> future = downloadTask.download(false, new Bounds(rectangle2D), progressMonitor2);
        this.taskFutures.add(future);
        this.tasks.add(downloadTask);
    }

    public Future<?> download(boolean bl, List<Rectangle2D> list, boolean bl2, boolean bl3, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (bl) {
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.getLayerManager().addLayer(osmDataLayer);
            Main.getLayerManager().setActiveLayer(osmDataLayer);
        }
        int n = (bl2 && bl3 ? 2 : 1) * list.size();
        progressMonitor.beginTask(null, n);
        int n2 = 0;
        for (Rectangle2D rectangle2D : list) {
            ++n2;
            if (bl2) {
                this.addDownloadTask(progressMonitor, new DownloadOsmTask(), rectangle2D, n2, n);
            }
            if (!bl3) continue;
            this.addDownloadTask(progressMonitor, new DownloadGpsTask(), rectangle2D, n2, n);
        }
        progressMonitor.addCancelListener(new ProgressMonitor.CancelListener(){

            @Override
            public void operationCanceled() {
                for (DownloadTask downloadTask : DownloadTaskList.this.tasks) {
                    downloadTask.cancel();
                }
            }
        });
        return Main.worker.submit(new PostDownloadProcessor(bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> download(boolean bl, Collection<Area> collection, boolean bl2, boolean bl3, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data", new Object[0]));
        try {
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(collection.size());
            for (Area area : collection) {
                arrayList.add(area.getBounds2D());
            }
            Future<?> future = this.download(bl, (List<Rectangle2D>)arrayList, bl2, bl3, progressMonitor.createSubTaskMonitor(-1, false));
            return future;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet dataSet) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (osmPrimitive.isIncomplete() || osmPrimitive.isNew()) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : set) {
            if (osmPrimitive == null) continue;
            arrayList.add(osmPrimitive);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateSelectionAction.updatePrimitives(arrayList);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Check on the server", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to check whether objects in your local dataset are deleted on the server", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Ignore", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort and to resume editing", new Object[0]), null)};
        String string = "<html>" + I18n.trn("There is {0} object in your local dataset which might be deleted on the server.<br>If you later try to delete or update this the server is likely to report a conflict.", "There are {0} objects in your local dataset which might be deleted on the server.<br>If you later try to delete or update them the server is likely to report a conflict.", set.size(), set.size()) + "<br>" + I18n.trn("Click <strong>{0}</strong> to check the state of this object on the server.", "Click <strong>{0}</strong> to check the state of these objects on the server.", set.size(), buttonSpecArray[0].text) + "<br>" + I18n.tr("Click <strong>{0}</strong> to ignore.</html>", buttonSpecArray[1].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Deleted or moved objects", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Action/UpdateData#SyncPotentiallyDeletedObjects"));
        if (n != 0) {
            return;
        }
        this.updatePotentiallyDeletedPrimitives(set);
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (DownloadTask downloadTask : this.tasks) {
            DataSet dataSet;
            if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = (DataSet)((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
            hashSet.addAll(dataSet.allPrimitives());
        }
        return hashSet;
    }

    class PostDownloadProcessor
    implements Runnable {
        private final boolean osmData;

        PostDownloadProcessor(boolean bl) {
            this.osmData = bl;
        }

        @Override
        public void run() {
            Object object3;
            Object object22;
            DownloadTaskList.this.progressMonitor.finishTask();
            for (Object object22 : DownloadTaskList.this.taskFutures) {
                try {
                    object22.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    Main.error(exception);
                    return;
                }
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (Object object3 : DownloadTaskList.this.tasks) {
                linkedHashSet.addAll(object3.getErrorObjects());
            }
            if (!linkedHashSet.isEmpty()) {
                object22 = new ArrayList();
                object3 = linkedHashSet.iterator();
                while (object3.hasNext()) {
                    Object e = object3.next();
                    if (e instanceof String) {
                        object22.add((String)e);
                        continue;
                    }
                    if (!(e instanceof Exception)) continue;
                    object22.add(ExceptionUtil.explainException((Exception)e));
                }
                GuiHelper.runInEDT(new Runnable((Collection)object22){
                    final /* synthetic */ Collection val$items;
                    {
                        this.val$items = collection;
                    }

                    @Override
                    public void run() {
                        if (this.val$items.size() == 1 && I18n.tr("No data found in this area.", new Object[0]).equals(this.val$items.iterator().next())) {
                            new Notification((String)this.val$items.iterator().next()).setIcon(2).show();
                        } else {
                            JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("The following errors occurred during mass download: {0}", Utils.joinAsHtmlUnorderedList(this.val$items)) + "</html>", I18n.tr("Errors during download", new Object[0]), 0);
                        }
                    }
                });
                return;
            }
            for (Object object3 : DownloadTaskList.this.tasks) {
                Object object4;
                if (!(object3 instanceof AbstractDownloadTask) || !((AbstractDownloadTask)(object4 = (AbstractDownloadTask)object3)).isCanceled() && !((AbstractDownloadTask)object4).isFailed()) continue;
                return;
            }
            object22 = Main.getLayerManager().getEditLayer();
            if (object22 != null && this.osmData) {
                object3 = DownloadTaskList.this.getCompletePrimitives(((OsmDataLayer)object22).data);
                for (DownloadTask downloadTask : DownloadTaskList.this.tasks) {
                    DataSet dataSet;
                    if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = (DataSet)((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
                    for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
                        object3.remove(osmPrimitive);
                    }
                }
                if (!object3.isEmpty()) {
                    GuiHelper.runInEDT(new Runnable((Set)object3){
                        final /* synthetic */ Set val$myPrimitives;
                        {
                            this.val$myPrimitives = set;
                        }

                        @Override
                        public void run() {
                            DownloadTaskList.this.handlePotentiallyDeletedPrimitives(this.val$myPrimitives);
                        }
                    });
                }
            }
        }
    }
}

