/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;

public interface MapViewPaintable {
    public void paint(Graphics2D var1, MapView var2, Bounds var3);

    public static class MapViewEvent {
        private final MapView mapView;
        private final boolean temporaryLayer;

        public MapViewEvent(MapView mapView, boolean bl) {
            this.mapView = mapView;
            this.temporaryLayer = bl;
        }

        public MapView getMapView() {
            return this.mapView;
        }

        public boolean isTemporaryLayer() {
            return this.temporaryLayer;
        }

        public String toString() {
            return "AttachToMapViewEvent [mapView=" + this.mapView + ", temporaryLayer=" + this.temporaryLayer + "]";
        }
    }

    public static interface LayerPainter {
        public void paint(MapViewGraphics var1);

        public void detachFromMapView(MapViewEvent var1);
    }

    public static interface PaintableInvalidationListener {
        public void paintablInvalidated(PaintableInvalidationEvent var1);
    }

    public static class PaintableInvalidationEvent {
        private final MapViewPaintable paintable;

        public PaintableInvalidationEvent(MapViewPaintable mapViewPaintable) {
            this.paintable = mapViewPaintable;
        }

        public MapViewPaintable getLayer() {
            return this.paintable;
        }

        public String toString() {
            return "LayerInvalidationEvent [layer=" + this.paintable + ']';
        }
    }
}

