/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    private Naming() {
    }

    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (parsed.name == null) {
            return registry;
        }
        return registry.lookup(parsed.name);
    }

    public static void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (obj == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(parsed.name, obj);
    }

    public static void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        registry.unbind(parsed.name);
    }

    public static void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (obj == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.rebind(parsed.name, obj);
    }

    public static String[] list(String name) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        String prefix = "";
        if (parsed.port > 0 || !parsed.host.equals("")) {
            prefix = prefix + "//" + parsed.host;
        }
        if (parsed.port > 0) {
            prefix = prefix + ":" + parsed.port;
        }
        prefix = prefix + "/";
        String[] names = registry.list();
        for (int i = 0; i < names.length; ++i) {
            names[i] = prefix + names[i];
        }
        return names;
    }

    private static Registry getRegistry(ParsedNamingURL parsed) throws RemoteException {
        return LocateRegistry.getRegistry(parsed.host, parsed.port);
    }

    private static ParsedNamingURL parseURL(String str) throws MalformedURLException {
        try {
            return Naming.intParseURL(str);
        }
        catch (URISyntaxException ex) {
            MalformedURLException mue = new MalformedURLException("invalid URL String: " + str);
            mue.initCause(ex);
            int indexSchemeEnd = str.indexOf(58);
            int indexAuthorityBegin = str.indexOf("//:");
            if (indexAuthorityBegin < 0) {
                throw mue;
            }
            if (indexAuthorityBegin == 0 || indexSchemeEnd > 0 && indexAuthorityBegin == indexSchemeEnd + 1) {
                int indexHostBegin = indexAuthorityBegin + 2;
                String newStr = str.substring(0, indexHostBegin) + "localhost" + str.substring(indexHostBegin);
                try {
                    return Naming.intParseURL(newStr);
                }
                catch (URISyntaxException inte) {
                    throw mue;
                }
                catch (MalformedURLException inte) {
                    throw inte;
                }
            }
            throw mue;
        }
    }

    private static ParsedNamingURL intParseURL(String str) throws MalformedURLException, URISyntaxException {
        int port;
        String host;
        URI uri = new URI(str);
        if (uri.isOpaque()) {
            throw new MalformedURLException("not a hierarchical URL: " + str);
        }
        if (uri.getFragment() != null) {
            throw new MalformedURLException("invalid character, '#', in URL name: " + str);
        }
        if (uri.getQuery() != null) {
            throw new MalformedURLException("invalid character, '?', in URL name: " + str);
        }
        if (uri.getUserInfo() != null) {
            throw new MalformedURLException("invalid character, '@', in URL host: " + str);
        }
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals("rmi")) {
            throw new MalformedURLException("invalid URL scheme: " + str);
        }
        String name = uri.getPath();
        if (name != null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name.length() == 0) {
                name = null;
            }
        }
        if ((host = uri.getHost()) == null) {
            host = "";
            try {
                uri.parseServerAuthority();
            }
            catch (URISyntaxException use) {
                String authority = uri.getAuthority();
                if (authority != null && authority.startsWith(":")) {
                    authority = "localhost" + authority;
                    try {
                        uri = new URI(null, authority, null, null, null);
                        uri.parseServerAuthority();
                    }
                    catch (URISyntaxException use2) {
                        throw new MalformedURLException("invalid authority: " + str);
                    }
                }
                throw new MalformedURLException("invalid authority: " + str);
            }
        }
        if ((port = uri.getPort()) == -1) {
            port = 1099;
        }
        return new ParsedNamingURL(host, port, name);
    }

    private static class ParsedNamingURL {
        String host;
        int port;
        String name;

        ParsedNamingURL(String host, int port, String name) {
            this.host = host;
            this.port = port;
            this.name = name;
        }
    }
}

