/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.CLIHandler;
import org.netbeans.core.TimableEventQueue;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class CLIOptions2
extends CLIHandler
implements Runnable {
    private int cnt;
    private static final Logger LOG = Logger.getLogger(CLIOptions2.class.getName());
    private static final int EQ_TIMEOUT = 15000;
    private final RequestProcessor.Task task;
    static CLIOptions2 INSTANCE;

    public CLIOptions2() {
        super(2);
        INSTANCE = this;
        this.task = RequestProcessor.getDefault().create((Runnable)this);
    }

    protected int cli(CLIHandler.Args args) {
        return this.cli(args.getArguments());
    }

    final int cli(String[] stringArray) {
        if (this.cnt++ == 0) {
            return 0;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            LOG.fine("CLI running");
            SwingUtilities.invokeLater(this);
            this.task.schedule(15000);
        }
        return 0;
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            this.eqStuck();
            return;
        }
        LOG.fine("running in EQ");
        this.task.cancel();
        CLIOptions2.frontMainWindow();
    }

    private void eqStuck() {
        Thread thread = TimableEventQueue.eq;
        if (thread == null) {
            LOG.warning("event queue thread not determined");
            return;
        }
        StackTraceElement[] stackTraceElementArray = Thread.getAllStackTraces().get(thread);
        if (stackTraceElementArray == null) {
            LOG.log(Level.WARNING, "no stack trace available for {0}", thread);
            return;
        }
        LOG.log(Level.INFO, "EQ stuck in " + thread, new EQStuck(stackTraceElementArray));
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.7")) >= 0) {
            LOG.log(Level.WARNING, "#198918: will not hard restart EQ when running on JDK 7");
            thread.interrupt();
            return;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!stackTraceElement.getMethodName().equals("<clinit>")) continue;
            LOG.log(Level.WARNING, "Will not hard restart EQ when inside a static initializer: {0}", stackTraceElement);
            thread.interrupt();
            return;
        }
        thread.stop();
    }

    private static void frontMainWindow() {
        Frame frame = WindowManager.getDefault().getMainWindow();
        frame.setVisible(true);
        if ((frame.getExtendedState() & 1) != 0) {
            frame.setExtendedState(0xFFFFFFFE & frame.getExtendedState());
        }
        frame.toFront();
    }

    protected void usage(PrintWriter printWriter) {
    }

    private static class EQStuck
    extends Throwable {
        EQStuck(StackTraceElement[] stackTraceElementArray) {
            super("GUI is not responsive");
            this.setStackTrace(stackTraceElementArray);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

