/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultOperatingSystem;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;

public class DefaultNativePlatform
implements NativePlatformInternal {
    private final String name;
    private ArchitectureInternal architecture;
    private OperatingSystemInternal operatingSystem;

    public DefaultNativePlatform(String name) {
        this(name, DefaultNativePlatform.getCurrentOperatingSystem(), DefaultNativePlatform.getCurrentArchitecture());
    }

    protected DefaultNativePlatform(String name, OperatingSystemInternal operatingSystem, ArchitectureInternal architecture) {
        this.name = name;
        this.architecture = architecture;
        this.operatingSystem = operatingSystem;
    }

    private static DefaultOperatingSystem getCurrentOperatingSystem() {
        return new DefaultOperatingSystem(System.getProperty("os.name"), OperatingSystem.current());
    }

    public static ArchitectureInternal getCurrentArchitecture() {
        String architectureName;
        try {
            architectureName = ((SystemInfo)NativeServices.getInstance().get(SystemInfo.class)).getArchitectureName();
        }
        catch (NativeIntegrationUnavailableException e) {
            architectureName = System.getProperty("os.arch");
        }
        return Architectures.forInput(architectureName);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("platform '%s'", this.name);
    }

    public ArchitectureInternal getArchitecture() {
        return this.architecture;
    }

    public void architecture(String name) {
        this.architecture = Architectures.forInput(name);
    }

    public OperatingSystemInternal getOperatingSystem() {
        return this.operatingSystem;
    }

    public void operatingSystem(String name) {
        this.operatingSystem = new DefaultOperatingSystem(name);
    }

    public String getCompatibilityString() {
        return this.getArchitecture().getName() + ":" + this.getOperatingSystem().getName();
    }
}

