/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.toolchain;

import org.gradle.internal.text.TreeFormatter;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChainAvailability
implements ToolSearchResult {
    private ToolSearchResult reason;

    @Override
    public boolean isAvailable() {
        return this.reason == null;
    }

    public String getUnavailableMessage() {
        TreeFormatter formatter = new TreeFormatter();
        this.explain((TreeVisitor<? super String>)formatter);
        return formatter.toString();
    }

    @Override
    public void explain(TreeVisitor<? super String> visitor) {
        this.reason.explain(visitor);
    }

    public ToolChainAvailability unavailable(String unavailableMessage) {
        if (this.reason == null) {
            this.reason = new FixedMessageToolSearchResult(unavailableMessage);
        }
        return this;
    }

    public ToolChainAvailability mustBeAvailable(ToolSearchResult tool) {
        if (!tool.isAvailable() && this.reason == null) {
            this.reason = tool;
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedMessageToolSearchResult
    implements ToolSearchResult {
        private final String message;

        private FixedMessageToolSearchResult(String message) {
            this.message = message;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }
}

