/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.GradleProperties;
import org.gradle.process.internal.JvmOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesToDaemonParametersConverter {
    public void convert(Map<String, String> properties, DaemonParameters target) {
        String daemonEnabledPropertyValue;
        String prop = properties.get("org.gradle.daemon.idletimeout");
        if (prop != null) {
            try {
                target.setIdleTimeout(new Integer(prop));
            }
            catch (NumberFormatException e) {
                throw new GradleException(String.format("Unable to parse %s property. The value should be an int but is: %s", "org.gradle.daemon.idletimeout", prop));
            }
        }
        if ((prop = properties.get("org.gradle.daemon.healthcheckinterval")) != null) {
            try {
                target.setPeriodicCheckInterval(new Integer(prop));
            }
            catch (NumberFormatException e) {
                throw new GradleException(String.format("Unable to parse %s property. Expected an int but got: %s", "org.gradle.daemon.healthcheckinterval", prop), e);
            }
        }
        if ((prop = properties.get("org.gradle.jvmargs")) != null) {
            target.setJvmArgs(JvmOptions.fromString(prop));
        }
        if ((prop = properties.get("org.gradle.java.home")) != null) {
            JavaInfo jvm;
            File javaHome = new File(prop);
            if (!javaHome.isDirectory()) {
                throw new GradleException(String.format("Java home supplied via '%s' is invalid. Invalid directory: %s", "org.gradle.java.home", prop));
            }
            try {
                jvm = Jvm.forHome(javaHome);
            }
            catch (JavaHomeException e) {
                throw new GradleException(String.format("Java home supplied via '%s' seems to be invalid: %s", "org.gradle.java.home", prop));
            }
            target.setJvm(jvm);
        }
        if ((prop = properties.get("org.gradle.daemon.registry.base")) != null) {
            target.setBaseDir(new File(prop));
        }
        if ((daemonEnabledPropertyValue = properties.get("org.gradle.daemon")) != null) {
            target.setEnabled(GradleProperties.isTrue(daemonEnabledPropertyValue));
        }
        target.setDebug(GradleProperties.isTrue(properties.get("org.gradle.debug")));
    }
}

