/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;

public class DaemonRegistryUnavailableExpirationStrategy
implements DaemonExpirationStrategy {
    private static final Logger LOG = Logging.getLogger(DaemonRegistryUnavailableExpirationStrategy.class);

    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        try {
            DaemonContext daemonContext = daemon.getDaemonContext();
            File daemonRegistryDir = daemonContext.getDaemonRegistryDir();
            if (!new DaemonDir(daemonRegistryDir).getRegistry().canRead()) {
                LOG.warn("Daemon registry {} became unreadable. Expiring daemon.", (Object)daemonRegistryDir);
                return new DaemonExpirationResult(true, "daemon registry became unreadable");
            }
            List allDaemonPids = Lists.transform(daemon.getDaemonRegistry().getAll(), (Function)new Function<DaemonInfo, Long>(){

                public Long apply(DaemonInfo info) {
                    return info.getPid();
                }
            });
            if (!allDaemonPids.contains(daemonContext.getPid())) {
                return new DaemonExpirationResult(true, "daemon registry entry unexpectedly lost");
            }
        }
        catch (SecurityException se) {
            LOG.warn("Daemon registry became inaccessible. Expiring daemon. Error message is '{}'", (Object)se.getMessage());
            return new DaemonExpirationResult(true, "daemon registry became inaccessible");
        }
        return new DaemonExpirationResult(false, null);
    }
}

