/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.MemoryInfo;

public class LowMemoryDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final MemoryInfo memoryInfo;
    protected final long minFreeMemoryBytes;

    private LowMemoryDaemonExpirationStrategy(MemoryInfo memoryInfo, long minFreeMemoryBytes) {
        Preconditions.checkArgument((minFreeMemoryBytes >= 0L ? 1 : 0) != 0);
        this.memoryInfo = (MemoryInfo)Preconditions.checkNotNull((Object)memoryInfo);
        this.minFreeMemoryBytes = minFreeMemoryBytes;
    }

    public static LowMemoryDaemonExpirationStrategy belowFreeBytes(long minFreeMemoryBytes) {
        return new LowMemoryDaemonExpirationStrategy(new MemoryInfo(), minFreeMemoryBytes);
    }

    public static LowMemoryDaemonExpirationStrategy belowFreePercentage(double minFreeMemoryPercentage) {
        return LowMemoryDaemonExpirationStrategy.belowFreePercentage(minFreeMemoryPercentage, new MemoryInfo());
    }

    @VisibleForTesting
    static LowMemoryDaemonExpirationStrategy belowFreePercentage(double minFreeMemoryPercentage, MemoryInfo memInfo) {
        Preconditions.checkArgument((minFreeMemoryPercentage >= 0.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be >= 0");
        Preconditions.checkArgument((minFreeMemoryPercentage <= 1.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be <= 1");
        return new LowMemoryDaemonExpirationStrategy(memInfo, (long)((double)memInfo.getTotalPhysicalMemory() * minFreeMemoryPercentage));
    }

    public DaemonExpirationResult checkExpiration(Daemon daemon) {
        long freeMem = this.memoryInfo.getFreePhysicalMemory();
        if (freeMem < this.minFreeMemoryBytes) {
            return new DaemonExpirationResult(true, "Free system memory (" + Long.toString(freeMem) + " bytes) is below threshold of " + Long.toString(this.minFreeMemoryBytes) + " bytes");
        }
        return new DaemonExpirationResult(false, null);
    }
}

