/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.javascript;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.RelativeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptCompileDestinationCalculator
implements Transformer<File, RelativeFile> {
    private final File destinationDir;

    public JavaScriptCompileDestinationCalculator(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public File transform(RelativeFile file) {
        File outputFileDir = new File(this.destinationDir, file.getRelativePath().getParent().getPathString());
        return new File(outputFileDir, JavaScriptCompileDestinationCalculator.getMinifiedFileName(file.getFile().getName()));
    }

    private static String getMinifiedFileName(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex == -1) {
            return fileName + ".min";
        }
        String prefix = fileName.substring(0, extIndex);
        String extension = fileName.substring(extIndex);
        return prefix + ".min" + extension;
    }
}

