/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output.definitions;

import java.io.File;
import java.util.List;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.definitions.FileLinkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestReportFileLinkDefinition
implements FileLinkDefinition {
    private String expression = this.prefix + ".*";
    private String prefix = "There were failing tests. See the report at ";

    @Override
    public String getSearchExpression() {
        return this.expression;
    }

    @Override
    public int parseFileLink(String fullSearchTest, String matchedText, int start, int end, boolean verifyFileExists, List<FileLink> fileLinks) {
        int indexOfPeriod = matchedText.lastIndexOf(46);
        if (indexOfPeriod == -1) {
            return -1;
        }
        String path = matchedText.substring(this.prefix.length(), indexOfPeriod).trim();
        File directory = new File(path);
        if (verifyFileExists && !directory.exists()) {
            return -1;
        }
        File file = new File(directory, "index.html");
        if (verifyFileExists && !file.exists()) {
            return -1;
        }
        fileLinks.add(new FileLink(file, start + this.prefix.length(), end, -1, this));
        return end;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "TestReportFileLinkDefinition";
    }
}

