/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.dsl.DependencyResultSpecNotationConverter;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class DependencyInsightReportTask
extends DefaultTask
implements GroovyObject {
    private Configuration configuration;
    private Spec<DependencyResult> dependencySpec;
    private transient MetaClass metaClass;

    public Object getProperty(String property) {
        return this.getMetaClass().getProperty((Object)this, property);
    }

    public Object invokeMethod(String name, Object args) {
        return this.getMetaClass().invokeMethod((Object)this, name, args);
    }

    public MetaClass getMetaClass() {
        if (this.metaClass == null) {
            this.metaClass = InvokerHelper.getMetaClass(((Object)((Object)this)).getClass());
        }
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Spec<DependencyResult> getDependencySpec() {
        return this.dependencySpec;
    }

    public void setDependencySpec(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Option(option="dependency", description="Shows the details of given dependency.")
    public void setDependencySpec(Object dependencyInsightNotation) {
        NotationParser<Object, Spec<DependencyResult>> parser = DependencyResultSpecNotationConverter.parser();
        this.dependencySpec = (Spec)parser.parseNotation(dependencyInsightNotation);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Option(option="configuration", description="Looks for the dependency in given configuration.")
    public void setConfiguration(String configurationName) {
        this.configuration = this.getProject().getConfigurations().getByName(configurationName);
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        final Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the input configuration was not specified. \nIt can be specified from the command line, e.g: '" + this.getPath() + " --configuration someConf --dependency someDep'");
        }
        if (this.dependencySpec == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the dependency to show was not specified.\nIt can be specified from the command line, e.g: '" + this.getPath() + " --dependency someDep'");
        }
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        GraphRenderer renderer = new GraphRenderer(output);
        ResolutionResult result = configuration.getIncoming().getResolutionResult();
        final LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        result.allDependencies((Action)new Action<DependencyResult>(){

            public void execute(DependencyResult dependencyResult) {
                if (DependencyInsightReportTask.this.dependencySpec.isSatisfiedBy((Object)dependencyResult)) {
                    selectedDependencies.add(dependencyResult);
                }
            }
        });
        if (selectedDependencies.isEmpty()) {
            output.println((Object)("No dependencies matching given input were found in " + String.valueOf(configuration)));
            return;
        }
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter().prepare(selectedDependencies, this.getVersionSelectorScheme(), this.getVersionComparator());
        NodeRenderer nodeRenderer = new NodeRenderer(){

            public void renderNode(StyledTextOutput target, RenderableDependency node, boolean alreadyRendered) {
                boolean leaf = node.getChildren().isEmpty();
                target.text((Object)(leaf ? configuration.getName() : node.getName()));
                if (alreadyRendered && !leaf) {
                    target.withStyle(StyledTextOutput.Style.Info).text((Object)" (*)");
                }
            }
        };
        DependencyGraphRenderer dependencyGraphRenderer = new DependencyGraphRenderer(renderer, nodeRenderer);
        int i = 1;
        for (final RenderableDependency dependency : sortedDeps) {
            boolean last;
            renderer.visit((Action)new Action<StyledTextOutput>(){

                public void execute(StyledTextOutput out) {
                    out.withStyle(StyledTextOutput.Style.Identifier).text((Object)dependency.getName());
                    if (StringUtils.isNotEmpty((String)dependency.getDescription())) {
                        out.withStyle(StyledTextOutput.Style.Description).text((Object)(" (" + dependency.getDescription() + ")"));
                    }
                    if (!dependency.isResolvable()) {
                        out.withStyle(StyledTextOutput.Style.Failure).text((Object)" FAILED");
                    }
                }
            }, true);
            dependencyGraphRenderer.render(dependency);
            if (last = i++ == sortedDeps.size()) continue;
            output.println();
        }
        dependencyGraphRenderer.printLegend();
    }
}

