/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.DefaultTextReportBuilder;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.GUtil;

public class TextReportRenderer
implements ReportRenderer {
    private BuildClientMetaData clientMetaData;
    private FileResolver fileResolver;
    private StyledTextOutput textOutput;
    private TextReportBuilder builder;
    private boolean close;

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setClientMetaData(BuildClientMetaData clientMetaData) {
        this.clientMetaData = clientMetaData;
    }

    public void setOutput(StyledTextOutput textOutput) {
        this.setWriter(textOutput, false);
    }

    public void setOutputFile(File file) throws IOException {
        this.cleanupWriter();
        this.setWriter((StyledTextOutput)new StreamingStyledTextOutput((Appendable)new BufferedWriter(new FileWriter(file))), true);
    }

    public void startProject(Project project) {
        String header = this.createHeader(project);
        this.builder.heading(header);
    }

    protected String createHeader(Project project) {
        String header = project.getRootProject() == project ? "Root project" : "Project " + project.getPath();
        if (GUtil.isTrue((Object)project.getDescription())) {
            header = header + " - " + project.getDescription();
        }
        return header;
    }

    public void completeProject(Project project) {
    }

    public void complete() {
        this.cleanupWriter();
    }

    private void setWriter(StyledTextOutput styledTextOutput, boolean close) {
        this.textOutput = styledTextOutput;
        this.builder = new DefaultTextReportBuilder(this.textOutput, this.fileResolver);
        this.close = close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWriter() {
        try {
            if (this.close) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.textOutput}).stop();
            }
        }
        finally {
            this.textOutput = null;
        }
    }

    public BuildClientMetaData getClientMetaData() {
        return this.clientMetaData;
    }

    public StyledTextOutput getTextOutput() {
        return this.textOutput;
    }

    public TextReportBuilder getBuilder() {
        return this.builder;
    }
}

