/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.internal.service.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyInjectingInstantiator
implements Instantiator {
    private final ServiceRegistry services;
    private final ConstructorCache cachedConstructors;

    public DependencyInjectingInstantiator(ServiceRegistry services, ConstructorCache cachedConstructors) {
        this.services = services;
        this.cachedConstructors = cachedConstructors;
    }

    public <T> T newInstance(Class<? extends T> type, Object ... parameters) {
        try {
            CachedConstructor cached = this.cachedConstructors.get(type);
            if (cached.error != null) {
                throw cached.error;
            }
            Constructor constructor = cached.constructor;
            Object[] resolvedParameters = this.convertParameters(type, constructor, parameters);
            try {
                return type.cast(constructor.newInstance(resolvedParameters));
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            throw new ObjectInstantiationException(type, e);
        }
    }

    private <T> Object[] convertParameters(Class<T> type, Constructor<?> match, Object[] parameters) {
        Class<?>[] parameterTypes = match.getParameterTypes();
        if (parameterTypes.length < parameters.length) {
            throw new IllegalArgumentException(String.format("Too many parameters provided for constructor for class %s. Expected %s, received %s.", type.getName(), parameterTypes.length, parameters.length));
        }
        Object[] resolvedParameters = new Object[parameterTypes.length];
        int pos = 0;
        for (int i = 0; i < resolvedParameters.length; ++i) {
            Class targetType = parameterTypes[i];
            if (targetType.isPrimitive()) {
                targetType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(targetType);
            }
            if (pos < parameters.length && targetType.isInstance(parameters[pos])) {
                resolvedParameters[i] = parameters[pos];
                ++pos;
                continue;
            }
            resolvedParameters[i] = this.services.get(match.getGenericParameterTypes()[i]);
        }
        if (pos != parameters.length) {
            throw new IllegalArgumentException(String.format("Unexpected parameter provided for constructor for class %s.", type.getName()));
        }
        return resolvedParameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedConstructor {
        private final Constructor<?> constructor;
        private final Throwable error;

        private CachedConstructor(Constructor<?> constructor, Throwable error) {
            this.constructor = constructor;
            this.error = error;
        }

        public static CachedConstructor of(Constructor<?> ctor) {
            return new CachedConstructor(ctor, null);
        }

        public static CachedConstructor of(Throwable err) {
            return new CachedConstructor(null, err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorCache {
        private final LoadingCache<Class<?>, CachedConstructor> cachedConstructors = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, CachedConstructor>(){

            public CachedConstructor load(Class<?> type) throws Exception {
                try {
                    ConstructorCache.validateType(type);
                    Constructor constructor = ConstructorCache.selectConstructor(type);
                    constructor.setAccessible(true);
                    return CachedConstructor.of(constructor);
                }
                catch (Throwable e) {
                    return CachedConstructor.of(e);
                }
            }
        });

        private static boolean isPublicOrPackageScoped(Class<?> type, Constructor<?> constructor) {
            if (ConstructorCache.isPackagePrivate(type.getModifiers())) {
                return !Modifier.isPrivate(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers());
            }
            return Modifier.isPublic(constructor.getModifiers());
        }

        private static boolean isPackagePrivate(int modifiers) {
            return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
        }

        private static <T> void validateType(Class<T> type) {
            if (type.isInterface() || type.isAnnotation() || type.isEnum()) {
                throw new IllegalArgumentException(String.format("Type %s is not a class.", type.getName()));
            }
            if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s is a non-static inner class.", type.getName()));
            }
            if (Modifier.isAbstract(type.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s is an abstract class.", type.getName()));
            }
        }

        private static <T> Constructor<?> selectConstructor(Class<T> type) {
            Constructor<?> constructor;
            Constructor<?>[] constructors = type.getDeclaredConstructors();
            if (constructors.length == 1 && (constructor = constructors[0]).getParameterTypes().length == 0 && ConstructorCache.isPublicOrPackageScoped(type, constructor)) {
                return constructor;
            }
            ArrayList injectConstructors = new ArrayList();
            for (Constructor<?> constructor2 : constructors) {
                if (constructor2.getAnnotation(Inject.class) == null) continue;
                injectConstructors.add(constructor2);
            }
            if (injectConstructors.isEmpty()) {
                throw new IllegalArgumentException(String.format("Class %s has no constructor that is annotated with @Inject.", type.getName()));
            }
            if (injectConstructors.size() > 1) {
                throw new IllegalArgumentException(String.format("Class %s has multiple constructors that are annotated with @Inject.", type.getName()));
            }
            return (Constructor)injectConstructors.get(0);
        }

        public CachedConstructor get(Class<?> clazz) {
            return (CachedConstructor)this.cachedConstructors.getUnchecked(clazz);
        }
    }
}

