/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.cache.CacheAccess;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.TextResource;

public class CacheAccessingFileSnapshotter
implements FileSnapshotter {
    private final FileSnapshotter delegate;
    private final CacheAccess cacheAccess;

    public CacheAccessingFileSnapshotter(FileSnapshotter delegate, CacheAccess cacheAccess) {
        this.delegate = delegate;
        this.cacheAccess = cacheAccess;
    }

    public FileSnapshot snapshot(final TextResource resource) {
        return this.cacheAccess.useCache("snapshot(TextResource)", new Factory<FileSnapshot>(){

            public FileSnapshot create() {
                return CacheAccessingFileSnapshotter.this.delegate.snapshot(resource);
            }
        });
    }

    public FileSnapshot snapshot(final File file) {
        return this.cacheAccess.useCache("snapshot(File)", new Factory<FileSnapshot>(){

            public FileSnapshot create() {
                return CacheAccessingFileSnapshotter.this.delegate.snapshot(file);
            }
        });
    }

    public FileSnapshot snapshot(final FileTreeElement fileDetails) {
        return this.cacheAccess.useCache("snapshot(FileTreeElement)", new Factory<FileSnapshot>(){

            public FileSnapshot create() {
                return CacheAccessingFileSnapshotter.this.delegate.snapshot(fileDetails);
            }
        });
    }

    public HashValue hash(final File file) {
        return this.cacheAccess.useCache("hash(File)", new Factory<HashValue>(){

            public HashValue create() {
                return CacheAccessingFileSnapshotter.this.delegate.hash(file);
            }
        });
    }
}

