/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.CachingTreeVisitor;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotterSerializer;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.TreeSnapshotRepository;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionSnapshotter
extends AbstractFileCollectionSnapshotter {
    private final CachingTreeVisitor treeVisitor;
    private final TreeSnapshotRepository treeSnapshotRepository;

    public DefaultFileCollectionSnapshotter(FileSnapshotter snapshotter, TaskArtifactStateCacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver, CachingTreeVisitor treeVisitor, TreeSnapshotRepository treeSnapshotRepository) {
        super(snapshotter, cacheAccess, stringInterner, fileResolver);
        this.treeVisitor = treeVisitor;
        this.treeSnapshotRepository = treeSnapshotRepository;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        registry.register(FileCollectionSnapshotImpl.class, (Serializer)new DefaultFileSnapshotterSerializer(this.stringInterner, this.treeSnapshotRepository));
    }

    @Override
    VisitedTree createJoinedTree(List<VisitedTree> nonShareableTrees, Collection<File> missingFiles) {
        return this.treeVisitor.createJoinedTree(nonShareableTrees, missingFiles);
    }

    @Override
    protected void visitFiles(FileCollection input, List<VisitedTree> visitedTrees, List<File> missingFiles, boolean allowReuse) {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(this.fileResolver);
        context.add(input);
        List<FileTreeInternal> fileTrees = context.resolveAsFileTrees();
        for (FileTreeInternal fileTree : fileTrees) {
            visitedTrees.add(this.treeVisitor.visitTreeForSnapshotting(fileTree, allowReuse));
        }
    }
}

