/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedList;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.internal.metaobject.BeanDynamicObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntFileCollectionMatchingTaskBuilder
implements AntBuilderAware {
    private final Iterable<DirectoryFileTree> fileTrees;

    public AntFileCollectionMatchingTaskBuilder(Iterable<DirectoryFileTree> fileTrees) {
        this.fileTrees = fileTrees;
    }

    @Override
    public Object addToAntBuilder(final Object node, String childNodeName) {
        final BeanDynamicObject dynamicObject = new BeanDynamicObject(node);
        final LinkedList existing = Lists.newLinkedList((Iterable)FluentIterable.from(this.fileTrees).filter((Predicate)new Predicate<DirectoryFileTree>(){

            public boolean apply(DirectoryFileTree input) {
                return input.getDir().exists();
            }
        }));
        for (DirectoryFileTree fileTree : existing) {
            dynamicObject.invokeMethod(childNodeName, Collections.singletonMap("location", fileTree.getDir()));
        }
        dynamicObject.invokeMethod("or", new Closure<Void>((Object)this){

            public Object doCall(Object ignore) {
                for (final DirectoryFileTree fileTree : existing) {
                    dynamicObject.invokeMethod("and", new Closure<Void>((Object)this){

                        public Object doCall(Object ignore) {
                            dynamicObject.invokeMethod("gradleBaseDirSelector", Collections.singletonMap("baseDir", fileTree.getDir()));
                            fileTree.getPatterns().addToAntBuilder(node, null);
                            return null;
                        }
                    });
                }
                return null;
            }
        });
        return node;
    }
}

