/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import java.util.concurrent.Callable;
import org.gradle.api.internal.file.archive.TarCopyAction;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.file.archive.compression.SimpleCompressor;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;

public class Tar
extends AbstractArchiveTask {
    private Compression compression = Compression.NONE;

    public Tar() {
        this.getConventionMapping().map("extension", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return Tar.this.getCompression().getDefaultExtension();
            }
        });
    }

    protected CopyAction createCopyAction() {
        return new TarCopyAction(this.getArchivePath(), this.getCompressor());
    }

    private ArchiveOutputStreamFactory getCompressor() {
        switch (this.compression) {
            case BZIP2: {
                return Bzip2Archiver.getCompressor();
            }
            case GZIP: {
                return GzipArchiver.getCompressor();
            }
        }
        return new SimpleCompressor();
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }
}

