/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import java.nio.charset.Charset;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.archive.ZipCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.DefaultZipCompressor;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.ZipEntryCompression;
import org.gradle.util.DeprecationLogger;

public class Zip
extends AbstractArchiveTask {
    public static final String ZIP_EXTENSION = "zip";
    private ZipEntryCompression entryCompression = ZipEntryCompression.DEFLATED;
    private boolean allowZip64;
    private String metadataCharset;

    public Zip() {
        this.setExtension(ZIP_EXTENSION);
        this.allowZip64 = false;
    }

    protected ZipCompressor getCompressor() {
        switch (this.entryCompression) {
            case DEFLATED: {
                return new DefaultZipCompressor(this.allowZip64, 8);
            }
            case STORED: {
                return new DefaultZipCompressor(this.allowZip64, 0);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown Compression type %s", new Object[]{this.entryCompression}));
    }

    protected CopyAction createCopyAction() {
        DocumentationRegistry documentationRegistry = (DocumentationRegistry)this.getServices().get(DocumentationRegistry.class);
        return new ZipCopyAction(this.getArchivePath(), this.getCompressor(), documentationRegistry, this.metadataCharset);
    }

    public ZipEntryCompression getEntryCompression() {
        return this.entryCompression;
    }

    public void setEntryCompression(ZipEntryCompression entryCompression) {
        this.entryCompression = entryCompression;
    }

    @Incubating
    public void setZip64(boolean allowZip64) {
        this.allowZip64 = allowZip64;
    }

    @Incubating
    public boolean isZip64() {
        return this.allowZip64;
    }

    @Incubating
    @Input
    @Optional
    public String getMetadataCharset() {
        return this.metadataCharset;
    }

    @Incubating
    public void setMetadataCharset(String metadataCharset) {
        if (metadataCharset == null) {
            throw new InvalidUserDataException("metadataCharset must not be null");
        }
        if (!Charset.isSupported(metadataCharset)) {
            throw new InvalidUserDataException(String.format("Charset for metadataCharset '%s' is not supported by your JVM", metadataCharset));
        }
        this.metadataCharset = metadataCharset;
    }

    @Deprecated
    public String getEncoding() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"Zip.encoding", (String)"metadataCharset");
        return this.getMetadataCharset();
    }

    @Deprecated
    public void setEncoding(String encoding) {
        DeprecationLogger.nagUserOfReplacedProperty((String)"Zip.encoding", (String)"metadataCharset");
        this.setMetadataCharset(encoding);
    }

    @Deprecated
    protected class ZipCopyActionImpl {
        protected ZipCopyActionImpl() {
        }
    }
}

