/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.LinkedList;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class DependencyResolutionLogger
implements DependencyResolutionListener {
    private final ThreadLocal<LinkedList<ProgressLogger>> progressLoggers = new ThreadLocal<LinkedList<ProgressLogger>>(){

        @Override
        protected LinkedList<ProgressLogger> initialValue() {
            return new LinkedList<ProgressLogger>();
        }
    };
    private final ProgressLoggerFactory loggerFactory;

    public DependencyResolutionLogger(ProgressLoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        LinkedList<ProgressLogger> loggers = this.progressLoggers.get();
        this.progressLoggers.set(loggers);
        ProgressLogger logger = this.loggerFactory.newOperation(DependencyResolutionLogger.class);
        logger.start("Resolve " + dependencies, "Resolving " + dependencies);
        loggers.add(logger);
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        LinkedList<ProgressLogger> loggers = this.progressLoggers.get();
        if (loggers.isEmpty()) {
            throw new IllegalStateException("Logging operation was not started or it has already completed.");
        }
        ProgressLogger logger = loggers.removeLast();
        logger.completed();
        if (loggers.isEmpty()) {
            this.progressLoggers.remove();
        }
    }
}

