/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.idea;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.JavaClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEACoverageClassInfo
extends JavaClassInfo {
    private ClassData myClassData;
    private Collection<ClassData> myInnerClasses;

    public IDEACoverageClassInfo(@NotNull String className, @Nullable ClassData classData, @NotNull Collection<ClassData> innerClasses) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageClassInfo.<init> must not be null");
        }
        if (innerClasses == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageClassInfo.<init> must not be null");
        }
        super(className);
        this.myClassData = classData;
        this.myInnerClasses = innerClasses;
    }

    @NotNull
    public Collection<ClassData> getClassDataWithInternal() {
        ArrayList<ClassData> list = new ArrayList<ClassData>();
        if (this.myClassData != null) {
            list.add(this.myClassData);
        }
        list.addAll(this.myInnerClasses);
        ArrayList<ClassData> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/idea/IDEACoverageClassInfo.getClassDataWithInternal must not return null");
        }
        return arrayList;
    }

    public Entry getLineStats() {
        int total = 0;
        int covered = 0;
        if (this.myClassData == null) {
            return null;
        }
        Object[] lines = this.myClassData.getLines();
        if (lines == null) {
            return null;
        }
        for (Object obj : lines) {
            if (obj == null) continue;
            ++total;
            LineData ld = (LineData)obj;
            if (!this.isCovered(ld.getStatus())) continue;
            ++covered;
        }
        return new Entry(total, covered);
    }

    @Nullable
    public Entry getMethodStats() {
        int total = 0;
        int covered = 0;
        if (this.myClassData == null) {
            return null;
        }
        for (Object m : this.myClassData.getMethodSigs()) {
            ++total;
            Integer status = this.myClassData.getStatus((String)m);
            if (!this.isCovered(status)) continue;
            ++covered;
        }
        return new Entry(total, covered);
    }

    public Entry getBlockStats() {
        return null;
    }

    public Entry getStatementStats() {
        return null;
    }

    public List<ClassInfo> getInnerClasses() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassData inner : this.myInnerClasses) {
            result.add((ClassInfo)new IDEACoverageClassInfo(inner.getName(), inner, Collections.<ClassData>emptyList()));
        }
        return result;
    }

    private boolean isCovered(Integer status) {
        if (status == null) {
            return false;
        }
        switch ((byte)status.intValue()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }
}

