/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntFilesProvider;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomPattern;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntDomFilesProviderImpl
extends AntDomElement
implements AntFilesProvider {
    private volatile List<File> myCachedFiles;

    @Attribute(value="defaultexcludes")
    public abstract GenericAttributeValue<String> getDefaultExcludes();

    @Attribute(value="casesensitive")
    public abstract GenericAttributeValue<String> getCaseSensitive();

    @Override
    @NotNull
    public final List<File> getFiles(Set<AntFilesProvider> processed) {
        if (processed.contains(this)) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFilesProviderImpl", "getFiles"));
            }
            return list;
        }
        List<File> result = this.myCachedFiles;
        if (result == null) {
            this.myCachedFiles = result = this.getFilesImpl(processed);
        }
        List<File> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFilesProviderImpl", "getFiles"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getFilesImpl(Set<AntFilesProvider> processed) {
        processed.add(this);
        try {
            AntDomElement referenced = (AntDomElement)this.getRefId().getValue();
            if (referenced instanceof AntFilesProvider) {
                List<File> list = ((AntFilesProvider)((Object)referenced)).getFiles(processed);
                return list;
            }
            List<File> list = this.getFiles(this.getAntPattern(), processed);
            return list;
        }
        finally {
            processed.remove(this);
        }
    }

    @Nullable
    protected AntDomPattern getAntPattern() {
        return AntDomPattern.create(this, this.shouldHonorDefaultExcludes(), this.matchPatternsCaseSensitive());
    }

    @NotNull
    protected List<File> getFiles(@Nullable AntDomPattern pattern, Set<AntFilesProvider> processed) {
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFilesProviderImpl", "getFiles"));
        }
        return list;
    }

    private boolean shouldHonorDefaultExcludes() {
        String value = this.getDefaultExcludes().getRawText();
        return value == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    private boolean matchPatternsCaseSensitive() {
        String value = this.getCaseSensitive().getRawText();
        return value == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    @Nullable
    protected File getCanonicalFile(String path) {
        if (path == null) {
            return null;
        }
        try {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file.getCanonicalFile();
            }
            String baseDir = this.getContextAntProject().getProjectBasedirPath();
            if (baseDir == null) {
                return null;
            }
            return new File(PathUtil.getCanonicalPath((String)new File(baseDir, path).getPath()));
        }
        catch (IOException e) {
            return null;
        }
    }
}

