/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomMacroDef;
import com.intellij.lang.ant.dom.AntDomMacrodefAttributeReference;
import com.intellij.lang.ant.dom.AntDomPropertyReference;
import com.intellij.lang.ant.dom.AntStringResolver;
import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AntReferenceInjector
implements DomReferenceInjector {
    AntReferenceInjector() {
    }

    public String resolveString(@Nullable String unresolvedText, @NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ant/dom/AntReferenceInjector", "resolveString"));
        }
        if (unresolvedText == null) {
            return null;
        }
        DomElement element = context.getInvocationElement();
        return AntStringResolver.computeString(element, unresolvedText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiReference[] inject(@Nullable String unresolvedText, @NotNull PsiElement element, @NotNull ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ant/dom/AntReferenceInjector", "inject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ant/dom/AntReferenceInjector", "inject"));
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray;
            List<PsiReference> refs;
            block7: {
                XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)element;
                refs = PsiReferenceListSpinAllocator.alloc();
                AntReferenceInjector.addPropertyReferences(context, xmlAttributeValue, refs);
                AntReferenceInjector.addMacrodefParameterRefs(xmlAttributeValue, refs);
                psiReferenceArray = refs.size() == 0 ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, (Object[])new PsiReference[refs.size()]);
                if (psiReferenceArray != null) break block7;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntReferenceInjector", "inject"));
            }
            return psiReferenceArray;
            finally {
                PsiReferenceListSpinAllocator.dispose(refs);
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntReferenceInjector", "inject"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static void addPropertyReferences(@NotNull ConvertContext context, XmlAttributeValue xmlAttributeValue, Collection<PsiReference> result) {
        String name;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ant/dom/AntReferenceInjector", "addPropertyReferences"));
        }
        String value = xmlAttributeValue.getValue();
        DomElement contextElement = context.getInvocationElement();
        XmlAttribute attrib = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlAttribute.class);
        if (attrib != null && ("if".equals(name = attrib.getName()) || "unless".equals(name))) {
            AntDomPropertyReference ref = new AntDomPropertyReference(contextElement, xmlAttributeValue, ElementManipulators.getValueTextRange((PsiElement)xmlAttributeValue));
            ref.setShouldBeSkippedByAnnotator(true);
            result.add((PsiReference)ref);
            return;
        }
        if (xmlAttributeValue != null) {
            int startIndex;
            int valueBeginingOffset = Math.abs(xmlAttributeValue.getTextRange().getStartOffset() - xmlAttributeValue.getValueTextRange().getStartOffset());
            int endIndex = -1;
            while ((startIndex = value.indexOf("${", endIndex + 1)) > endIndex) {
                if (startIndex > 0 && value.charAt(startIndex - 1) == '$') {
                    endIndex = startIndex + 1;
                    continue;
                }
                int nestedBrackets = 0;
                for (endIndex = startIndex += 2; value.length() > endIndex; ++endIndex) {
                    char ch = value.charAt(endIndex);
                    if (ch == '}') {
                        if (nestedBrackets == 0) break;
                        --nestedBrackets;
                        continue;
                    }
                    if (ch != '{') continue;
                    ++nestedBrackets;
                }
                if (nestedBrackets > 0 || endIndex > value.length()) {
                    return;
                }
                if (endIndex >= startIndex) {
                    AntDomPropertyReference ref = new AntDomPropertyReference(contextElement, xmlAttributeValue, new TextRange(valueBeginingOffset + startIndex, valueBeginingOffset + endIndex));
                    result.add((PsiReference)ref);
                }
                endIndex = startIndex;
            }
        }
    }

    public static void addMacrodefParameterRefs(@NotNull XmlAttributeValue element, Collection<PsiReference> refs) {
        int startIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ant/dom/AntReferenceInjector", "addMacrodefParameterRefs"));
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        if (domElement == null) {
            return;
        }
        AntDomMacroDef macrodef = (AntDomMacroDef)domElement.getParentOfType(AntDomMacroDef.class, true);
        if (macrodef == null) {
            return;
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int valueBeginingOffset = Math.abs(element.getTextRange().getStartOffset() - element.getValueTextRange().getStartOffset());
        int endIndex = -1;
        while ((startIndex = text.indexOf("@{", endIndex + 1)) > endIndex) {
            int nestedBrackets = 0;
            for (endIndex = startIndex += 2; text.length() > endIndex; ++endIndex) {
                char ch = text.charAt(endIndex);
                if (ch == '}') {
                    if (nestedBrackets == 0) break;
                    --nestedBrackets;
                    continue;
                }
                if (ch != '{') continue;
                ++nestedBrackets;
            }
            if (nestedBrackets > 0 || endIndex == text.length()) {
                return;
            }
            if (endIndex >= startIndex) {
                refs.add((PsiReference)new AntDomMacrodefAttributeReference((PsiElement)element, new TextRange(valueBeginingOffset + startIndex, valueBeginingOffset + endIndex)));
            }
            endIndex = startIndex;
        }
    }
}

