/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.util.ServiceLoader;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;
import org.jetbrains.plugins.gradle.tooling.util.VersionMatcher;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private static ServiceLoader<ModelBuilderService> buildersLoader = ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader());
    @NotNull
    private final GradleVersion myCurrentGradleVersion;

    public ExtraModelBuilder() {
        this.myCurrentGradleVersion = GradleVersion.current();
    }

    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "<init>"));
        }
        this.myCurrentGradleVersion = gradleVersion;
    }

    public boolean canBuild(String modelName) {
        for (ModelBuilderService service : buildersLoader) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object buildAll(String modelName, Project project) {
        for (ModelBuilderService service : buildersLoader) {
            Object object;
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            long startTime = System.currentTimeMillis();
            try {
                object = service.buildAll(modelName, project);
            }
            catch (Exception e) {
                try {
                    ErrorMessageBuilder builderError = service.getErrorMessageBuilder(project, e);
                    project.getLogger().error(builderError.build());
                }
                catch (Throwable throwable) {
                    if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) throw throwable;
                    long timeInMs = System.currentTimeMillis() - startTime;
                    project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
                    throw throwable;
                }
                if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) return null;
                long timeInMs = System.currentTimeMillis() - startTime;
                project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
                return null;
            }
            if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) return object;
            long timeInMs = System.currentTimeMillis() - startTime;
            project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
            return object;
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private boolean isVersionMatch(@NotNull ModelBuilderService builderService) {
        if (builderService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderService", "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder", "isVersionMatch"));
        }
        TargetVersions targetVersions = builderService.getClass().getAnnotation(TargetVersions.class);
        return new VersionMatcher(this.myCurrentGradleVersion).isVersionMatch(targetVersions);
    }
}

