/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;

class CompositeFilter<T>
implements Filter<T> {
    private static final Filter ALWAYS_INCLUDED_FILTER = obj -> FilterResult.included("Always included");
    private static final FilterResult INCLUDED_BY_ALL_FILTERS = FilterResult.included("Element was included by all filters.");
    private final Collection<? extends Filter<T>> filters;

    static <T> Filter<T> alwaysIncluded() {
        return ALWAYS_INCLUDED_FILTER;
    }

    CompositeFilter(Collection<? extends Filter<T>> filters) {
        this.filters = filters;
    }

    @Override
    public FilterResult apply(T element) {
        return this.filters.stream().map(filter -> filter.apply(element)).filter(FilterResult::excluded).findFirst().orElse(INCLUDED_BY_ALL_FILTERS);
    }

    public String toString() {
        return this.filters.stream().map(Object::toString).map(value -> String.format("(%s)", value)).collect(Collectors.joining(" and "));
    }
}

