/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Optional;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;

@API(value=API.Usage.Experimental)
public interface Node<C extends EngineExecutionContext> {
    default public boolean isLeaf() {
        return false;
    }

    default public C prepare(C context) throws Exception {
        return context;
    }

    default public SkipResult shouldBeSkipped(C context) throws Exception {
        return SkipResult.doNotSkip();
    }

    default public C before(C context) throws Exception {
        return context;
    }

    default public C execute(C context) throws Exception {
        return context;
    }

    default public void after(C context) throws Exception {
    }

    public static class SkipResult {
        private static final SkipResult alwaysExecuteSkipResult = new SkipResult(false, null);
        private final boolean skipped;
        private final String reason;

        public static SkipResult skip(String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult doNotSkip() {
            return alwaysExecuteSkipResult;
        }

        private SkipResult(boolean skipped, String reason) {
            this.skipped = skipped;
            this.reason = reason;
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> getReason() {
            return Optional.ofNullable(this.reason);
        }
    }
}

