/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.instrumentation.PatternInstrumenter;
import org.jetbrains.jps.intellilang.model.InstrumentationException;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangConfiguration;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangExtensionService;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class PatternValidatorBuilder
extends BaseInstrumentingBuilder {
    @NotNull
    public String getPresentableName() {
        if ("IntelliLang Pattern Validator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/intellilang/instrumentation/PatternValidatorBuilder", "getPresentableName"));
        }
        return "IntelliLang Pattern Validator";
    }

    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(context.getProjectDescriptor().getModel().getGlobal());
        return config.getInstrumentationType() != InstrumentationType.NONE;
    }

    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return true;
    }

    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiled, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(context.getProjectDescriptor().getModel().getGlobal());
        PatternInstrumenter instrumenter = new PatternInstrumenter(config.getPatternAnnotationClass(), (ClassVisitor)writer, config.getInstrumentationType(), finder);
        try {
            reader.accept((ClassVisitor)instrumenter, 0);
            if (instrumenter.instrumented()) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (InstrumentationException e) {
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage()));
        }
        return null;
    }

    protected String getProgressMessage() {
        return "Adding pattern assertions...";
    }
}

