/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodFinder {
    private static final Pattern METHOD_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    MethodFinder() {
    }

    Optional<Method> findMethod(String methodSpecPart, Class<?> clazz) {
        Matcher matcher = METHOD_PATTERN.matcher(methodSpecPart);
        Preconditions.condition((boolean)matcher.matches(), () -> String.format("Method [%s] does not match pattern [%s]", methodSpecPart, METHOD_PATTERN));
        String methodName = matcher.group(1);
        Class[] parameterTypes = this.resolveParameterTypes(matcher.group(2));
        return ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])parameterTypes);
    }

    private Class<?>[] resolveParameterTypes(String params) {
        if (StringUtils.isBlank((String)params)) {
            return EMPTY_CLASS_ARRAY;
        }
        return (Class[])Arrays.stream(params.trim().split(",")).map(className -> this.loadRequiredParameterClass((String)className)).toArray(Class[]::new);
    }

    private Class<?> loadRequiredParameterClass(String className) {
        return (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new JUnitException(String.format("Failed to load parameter type [%s]", className)));
    }
}

